/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataInput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeDataOutput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeInputOutput;
import org.opendaylight.controller.cluster.datastore.node.utils.stream.NormalizedNodeStreamVersion;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractVersionedShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.PayloadVersion;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshotMetadata;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class MetadataShardDataTreeSnapshot
extends AbstractVersionedShardDataTreeSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="This field is not Serializable but this class implements writeReplace to delegate serialization to a Proxy class and thus instances of this class aren't serialized. FindBugs does not recognize this.")
    private final Map<Class<? extends ShardDataTreeSnapshotMetadata<?>>, ShardDataTreeSnapshotMetadata<?>> metadata;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="See above justification.")
    private final NormalizedNode<?, ?> rootNode;

    public MetadataShardDataTreeSnapshot(NormalizedNode<?, ?> rootNode) {
        this(rootNode, (Map<Class<? extends ShardDataTreeSnapshotMetadata<?>>, ShardDataTreeSnapshotMetadata<?>>)ImmutableMap.of());
    }

    public MetadataShardDataTreeSnapshot(NormalizedNode<?, ?> rootNode, Map<Class<? extends ShardDataTreeSnapshotMetadata<?>>, ShardDataTreeSnapshotMetadata<?>> metadata) {
        this.rootNode = Objects.requireNonNull(rootNode);
        this.metadata = ImmutableMap.copyOf(metadata);
    }

    public Map<Class<? extends ShardDataTreeSnapshotMetadata<?>>, ShardDataTreeSnapshotMetadata<?>> getMetadata() {
        return this.metadata;
    }

    @Override
    NormalizedNode<?, ?> rootNode() {
        return this.rootNode;
    }

    @Override
    PayloadVersion version() {
        return PayloadVersion.NEON_SR2;
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("metadata", this.metadata).toString();
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private static final Logger LOG = LoggerFactory.getLogger(MetadataShardDataTreeSnapshot.class);
        private Map<Class<? extends ShardDataTreeSnapshotMetadata<?>>, ShardDataTreeSnapshotMetadata<?>> metadata;
        private NormalizedNodeStreamVersion version;
        private NormalizedNode<?, ?> rootNode;

        public Proxy() {
        }

        Proxy(MetadataShardDataTreeSnapshot snapshot) {
            this.rootNode = snapshot.getRootNode().get();
            this.metadata = snapshot.getMetadata();
            this.version = snapshot.version().getStreamVersion();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.metadata.size());
            for (ShardDataTreeSnapshotMetadata<?> m : this.metadata.values()) {
                out.writeObject(m);
            }
            out.writeBoolean(true);
            try (NormalizedNodeDataOutput stream = NormalizedNodeInputOutput.newDataOutput((DataOutput)out, (NormalizedNodeStreamVersion)this.version);){
                stream.writeNormalizedNode(this.rootNode);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int metaSize = in.readInt();
            Preconditions.checkArgument((metaSize >= 0 ? 1 : 0) != 0, (String)"Invalid negative metadata map length %s", (int)metaSize);
            ImmutableMap.Builder metaBuilder = ImmutableMap.builder();
            for (int i = 0; i < metaSize; ++i) {
                ShardDataTreeSnapshotMetadata m = (ShardDataTreeSnapshotMetadata)in.readObject();
                if (m != null) {
                    metaBuilder.put(m.getType(), (Object)m);
                    continue;
                }
                LOG.warn("Skipping null metadata");
            }
            this.metadata = metaBuilder.build();
            boolean present = in.readBoolean();
            if (!present) {
                throw new StreamCorruptedException("Unexpected missing root node");
            }
            NormalizedNodeDataInput stream = NormalizedNodeInputOutput.newDataInput((DataInput)in);
            this.version = stream.getVersion();
            this.rootNode = stream.readNormalizedNode();
        }

        private Object readResolve() {
            return new MetadataShardDataTreeSnapshot(this.rootNode, this.metadata);
        }
    }
}

