/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import akka.actor.ActorRef;
import akka.actor.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.sharding.DOMDataTreeShardCreationFailedException;

abstract class LookupTask
implements Runnable {
    private final int maxRetries;
    private final ActorRef replyTo;
    private int retried = 0;

    LookupTask(ActorRef replyTo, int maxRetries) {
        this.replyTo = replyTo;
        this.maxRetries = maxRetries;
    }

    abstract void reschedule(int var1);

    void tryReschedule(@Nullable Throwable throwable) {
        if (this.retried <= this.maxRetries) {
            ++this.retried;
            this.reschedule(this.retried);
        } else {
            this.fail(throwable);
        }
    }

    void fail(@Nullable Throwable throwable) {
        if (throwable == null) {
            this.replyTo.tell((Object)new Status.Failure((Throwable)new DOMDataTreeShardCreationFailedException("Unable to find the backend shard.Failing..")), ActorRef.noSender());
        } else {
            this.replyTo.tell((Object)new Status.Failure((Throwable)new DOMDataTreeShardCreationFailedException("Unable to find the backend shard.Failing..", throwable)), ActorRef.noSender());
        }
    }
}

