/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class Percentage
implements TypeObject,
Serializable {
    private static final long serialVersionUID = 482899018947419815L;
    private final Short _value;

    private static void check_valueRange(short value) {
        if (value >= 0 && value <= 100) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..100]]", (int)value);
    }

    @ConstructorProperties(value={"value"})
    public Percentage(Short _value) {
        if (_value != null) {
            Percentage.check_valueRange(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public Percentage(Percentage source) {
        this._value = source._value;
    }

    public static Percentage getDefaultInstance(String defaultValue) {
        return new Percentage(Short.valueOf(defaultValue));
    }

    public Short getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Percentage other = (Percentage)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Percentage.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        return helper.toString();
    }
}

