/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.Entity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.EntityKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.entity.Candidate;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class EntityBuilder
implements Builder<Entity> {
    private List<Candidate> _candidate;
    private InstanceIdentifier<?> _id;
    private String _owner;
    private EntityKey key;
    Map<Class<? extends Augmentation<Entity>>, Augmentation<Entity>> augmentation = Collections.emptyMap();

    public EntityBuilder() {
    }

    public EntityBuilder(Entity base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>(aug);
        }
        this.key = base.key();
        this._id = base.getId();
        this._candidate = base.getCandidate();
        this._owner = base.getOwner();
    }

    public EntityKey key() {
        return this.key;
    }

    public List<Candidate> getCandidate() {
        return this._candidate;
    }

    public InstanceIdentifier<?> getId() {
        return this._id;
    }

    public String getOwner() {
        return this._owner;
    }

    public <E$$ extends Augmentation<Entity>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public EntityBuilder withKey(EntityKey key) {
        this.key = key;
        return this;
    }

    public EntityBuilder setCandidate(List<Candidate> values) {
        this._candidate = values;
        return this;
    }

    public EntityBuilder setId(InstanceIdentifier<?> value) {
        this._id = value;
        return this;
    }

    public EntityBuilder setOwner(String value) {
        this._owner = value;
        return this;
    }

    public EntityBuilder addAugmentation(Class<? extends Augmentation<Entity>> augmentationType, Augmentation<Entity> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public EntityBuilder removeAugmentation(Class<? extends Augmentation<Entity>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Entity build() {
        return new EntityImpl(this);
    }

    private static final class EntityImpl
    extends AbstractAugmentable<Entity>
    implements Entity {
        private final List<Candidate> _candidate;
        private final InstanceIdentifier<?> _id;
        private final String _owner;
        private final EntityKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        EntityImpl(EntityBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new EntityKey(base.getId());
            this._id = this.key.getId();
            this._candidate = base.getCandidate();
            this._owner = base.getOwner();
        }

        @Override
        public EntityKey key() {
            return this.key;
        }

        @Override
        public List<Candidate> getCandidate() {
            return this._candidate;
        }

        @Override
        public InstanceIdentifier<?> getId() {
            return this._id;
        }

        @Override
        public String getOwner() {
            return this._owner;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._candidate);
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._owner);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Entity.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Entity other = (Entity)obj;
            if (!Objects.equals(this._candidate, other.getCandidate())) {
                return false;
            }
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._owner, other.getOwner())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EntityImpl otherImpl = (EntityImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Entity");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_candidate", this._candidate);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_id", this._id);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_owner", (Object)this._owner);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

