/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;
import org.opendaylight.controller.cluster.access.commands.CreateLocalHistoryRequest;
import org.opendaylight.controller.cluster.access.commands.DestroyLocalHistoryRequest;
import org.opendaylight.controller.cluster.access.commands.LocalHistoryRequest;
import org.opendaylight.controller.cluster.access.commands.PurgeLocalHistoryRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalReadOnlyProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalReadWriteProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyReconnectCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.RemoteProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ReadOnlyDataTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ProxyHistory
implements Identifiable<LocalHistoryIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyHistory.class);
    private final Lock lock = new ReentrantLock();
    private final LocalHistoryIdentifier identifier;
    private final AbstractClientConnection<ShardBackendInfo> connection;
    private final AbstractClientHistory parent;
    private final @GuardedBy(value={"lock"}) Map<TransactionIdentifier, AbstractProxyTransaction> proxies = new LinkedHashMap<TransactionIdentifier, AbstractProxyTransaction>();
    private @GuardedBy(value={"lock"}) ProxyHistory successor;

    private ProxyHistory(AbstractClientHistory parent, AbstractClientConnection<ShardBackendInfo> connection, LocalHistoryIdentifier identifier) {
        this.parent = Objects.requireNonNull(parent);
        this.connection = Objects.requireNonNull(connection);
        this.identifier = Objects.requireNonNull(identifier);
    }

    static ProxyHistory createClient(AbstractClientHistory parent, AbstractClientConnection<ShardBackendInfo> connection, LocalHistoryIdentifier identifier) {
        Optional dataTree = connection.getBackendInfo().flatMap(ShardBackendInfo::getDataTree);
        return dataTree.isPresent() ? new Local(parent, connection, identifier, (ReadOnlyDataTree)dataTree.get()) : new Remote(parent, connection, identifier);
    }

    static ProxyHistory createSingle(AbstractClientHistory parent, AbstractClientConnection<ShardBackendInfo> connection, LocalHistoryIdentifier identifier) {
        Optional dataTree = connection.getBackendInfo().flatMap(ShardBackendInfo::getDataTree);
        return dataTree.isPresent() ? new LocalSingle(parent, connection, identifier, (ReadOnlyDataTree)dataTree.get()) : new RemoteSingle(parent, connection, identifier);
    }

    public LocalHistoryIdentifier getIdentifier() {
        return this.identifier;
    }

    final ClientActorContext context() {
        return this.connection.context();
    }

    final long currentTime() {
        return this.connection.currentTime();
    }

    final ActorRef localActor() {
        return this.connection.localActor();
    }

    final AbstractClientHistory parent() {
        return this.parent;
    }

    final AbstractProxyTransaction createTransactionProxy(TransactionIdentifier txId, boolean snapshotOnly) {
        return this.createTransactionProxy(txId, snapshotOnly, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractProxyTransaction createTransactionProxy(TransactionIdentifier txId, boolean snapshotOnly, boolean isDone) {
        this.lock.lock();
        try {
            if (this.successor != null) {
                AbstractProxyTransaction abstractProxyTransaction = this.successor.createTransactionProxy(txId, snapshotOnly, isDone);
                return abstractProxyTransaction;
            }
            TransactionIdentifier proxyId = new TransactionIdentifier(this.identifier, txId.getTransactionId());
            AbstractProxyTransaction ret = this.doCreateTransactionProxy(this.connection, proxyId, snapshotOnly, isDone);
            this.proxies.put(proxyId, ret);
            LOG.debug("Allocated proxy {} for transaction {}", (Object)proxyId, (Object)txId);
            AbstractProxyTransaction abstractProxyTransaction = ret;
            return abstractProxyTransaction;
        }
        finally {
            this.lock.unlock();
        }
    }

    final void abortTransaction(AbstractProxyTransaction tx) {
        this.lock.lock();
        try {
            LOG.debug("Proxy {} aborted transaction {}", (Object)this, (Object)tx);
            this.onTransactionAborted(tx);
        }
        finally {
            this.lock.unlock();
        }
    }

    final void completeTransaction(AbstractProxyTransaction tx) {
        this.lock.lock();
        try {
            LOG.debug("Proxy {} completing transaction {}", (Object)this, (Object)tx);
            this.onTransactionCompleted(tx);
        }
        finally {
            this.lock.unlock();
        }
    }

    void purgeTransaction(AbstractProxyTransaction tx) {
        this.lock.lock();
        try {
            this.proxies.remove(tx.getIdentifier());
            LOG.debug("Proxy {} purged transaction {}", (Object)this, (Object)tx);
        }
        finally {
            this.lock.unlock();
        }
    }

    final void close() {
        this.lock.lock();
        try {
            if (this.successor != null) {
                this.successor.close();
                return;
            }
            LOG.debug("Proxy {} invoking destroy", (Object)this);
            this.connection.sendRequest((Request)new DestroyLocalHistoryRequest(this.getIdentifier(), 1L, this.localActor()), this::onDestroyComplete);
        }
        finally {
            this.lock.unlock();
        }
    }

    final void enqueueRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        this.connection.enqueueRequest(request, callback, enqueuedTicks);
    }

    final void sendRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        this.connection.sendRequest(request, callback);
    }

    abstract @GuardedBy(value={"lock"}) AbstractProxyTransaction doCreateTransactionProxy(AbstractClientConnection<ShardBackendInfo> var1, TransactionIdentifier var2, boolean var3, boolean var4);

    abstract ProxyHistory createSuccessor(AbstractClientConnection<ShardBackendInfo> var1);

    @SuppressFBWarnings(value={"UL_UNRELEASED_LOCK"}, justification="Lock is released asynchronously via the cohort")
    ProxyReconnectCohort startReconnect(ConnectedClientConnection<ShardBackendInfo> newConnection) {
        this.lock.lock();
        if (this.successor != null) {
            this.lock.unlock();
            throw new IllegalStateException("Proxy history " + this + " already has a successor");
        }
        this.successor = this.createSuccessor((AbstractClientConnection<ShardBackendInfo>)newConnection);
        LOG.debug("History {} instantiated successor {}", (Object)this, (Object)this.successor);
        for (AbstractProxyTransaction t : this.proxies.values()) {
            t.startReconnect();
        }
        return new ReconnectCohort();
    }

    private void onDestroyComplete(Response<?, ?> response) {
        LOG.debug("Proxy {} destroy completed with {}", (Object)this, response);
        this.lock.lock();
        try {
            this.parent.onProxyDestroyed(this);
            this.connection.sendRequest((Request)new PurgeLocalHistoryRequest(this.getIdentifier(), 2L, this.localActor()), this::onPurgeComplete);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onPurgeComplete(Response<?, ?> response) {
        LOG.debug("Proxy {} purge completed with {}", (Object)this, response);
    }

    @Holding(value={"lock"})
    void onTransactionAborted(AbstractProxyTransaction tx) {
    }

    @Holding(value={"lock"})
    void onTransactionCompleted(AbstractProxyTransaction tx) {
    }

    void onTransactionSealed(AbstractProxyTransaction tx) {
    }

    private final class ReconnectCohort
    extends ProxyReconnectCohort {
        private ReconnectCohort() {
        }

        public LocalHistoryIdentifier getIdentifier() {
            return ProxyHistory.this.identifier;
        }

        @Override
        @Holding(value={"lock"})
        void replayRequests(Collection<ConnectionEntry> previousEntries) {
            Request req;
            Object e;
            Iterator<ConnectionEntry> it = previousEntries.iterator();
            while (it.hasNext()) {
                e = it.next();
                req = e.getRequest();
                if (!ProxyHistory.this.identifier.equals((Object)req.getTarget())) continue;
                Verify.verify((boolean)(req instanceof LocalHistoryRequest));
                if (!(req instanceof CreateLocalHistoryRequest)) continue;
                ProxyHistory.this.successor.connection.enqueueRequest(req, e.getCallback(), e.getEnqueuedTicks());
                it.remove();
                break;
            }
            for (AbstractProxyTransaction t : ProxyHistory.this.proxies.values()) {
                LOG.debug("{} replaying messages to old proxy {} towards successor {}", new Object[]{ProxyHistory.this.identifier, t, ProxyHistory.this.successor});
                t.replayMessages(ProxyHistory.this.successor, previousEntries);
            }
            it = previousEntries.iterator();
            while (it.hasNext()) {
                e = it.next();
                req = e.getRequest();
                if (!ProxyHistory.this.identifier.equals((Object)req.getTarget())) continue;
                Verify.verify((boolean)(req instanceof LocalHistoryRequest));
                if (!(req instanceof DestroyLocalHistoryRequest)) continue;
                ProxyHistory.this.successor.connection.enqueueRequest(req, e.getCallback(), e.getEnqueuedTicks());
                it.remove();
                break;
            }
        }

        @Override
        @GuardedBy(value={"lock"}) ProxyHistory finishReconnect() {
            ProxyHistory ret = (ProxyHistory)Verify.verifyNotNull((Object)ProxyHistory.this.successor);
            for (AbstractProxyTransaction t : ProxyHistory.this.proxies.values()) {
                t.finishReconnect();
            }
            LOG.debug("Finished reconnecting proxy history {}", (Object)this);
            ProxyHistory.this.lock.unlock();
            return ret;
        }

        @Override
        void replayEntry(ConnectionEntry entry, Consumer<ConnectionEntry> replayTo) throws RequestException {
            Request request = entry.getRequest();
            if (request instanceof TransactionRequest) {
                this.lookupProxy(request).replayRequest((TransactionRequest)request, entry.getCallback(), entry.getEnqueuedTicks());
            } else if (request instanceof LocalHistoryRequest) {
                replayTo.accept(entry);
            } else {
                throw new IllegalArgumentException("Unhandled request " + request);
            }
        }

        @Override
        void forwardEntry(ConnectionEntry entry, Consumer<ConnectionEntry> forwardTo) throws RequestException {
            Request request = entry.getRequest();
            if (request instanceof TransactionRequest) {
                this.lookupProxy(request).forwardRequest((TransactionRequest)request, entry.getCallback());
            } else if (request instanceof LocalHistoryRequest) {
                forwardTo.accept(entry);
            } else {
                throw new IllegalArgumentException("Unhandled request " + request);
            }
        }

        private AbstractProxyTransaction lookupProxy(Request<?, ?> request) throws RequestReplayException {
            AbstractProxyTransaction proxy;
            ProxyHistory.this.lock.lock();
            try {
                proxy = ProxyHistory.this.proxies.get(request.getTarget());
            }
            finally {
                ProxyHistory.this.lock.unlock();
            }
            if (proxy != null) {
                return proxy;
            }
            throw new RequestReplayException("Failed to find proxy for %s", request);
        }
    }

    private static final class RequestReplayException
    extends RequestException {
        private static final long serialVersionUID = 1L;

        RequestReplayException(String format, Object ... args) {
            super(String.format(format, args));
        }

        public boolean isRetriable() {
            return false;
        }
    }

    private static final class RemoteSingle
    extends AbstractRemote {
        RemoteSingle(AbstractClientHistory parent, AbstractClientConnection<ShardBackendInfo> connection, LocalHistoryIdentifier identifier) {
            super(parent, connection, identifier);
        }

        @Override
        AbstractProxyTransaction doCreateTransactionProxy(AbstractClientConnection<ShardBackendInfo> connection, TransactionIdentifier txId, boolean snapshotOnly, boolean isDone) {
            return new RemoteProxyTransaction(this, txId, snapshotOnly, false, isDone);
        }

        @Override
        ProxyHistory createSuccessor(AbstractClientConnection<ShardBackendInfo> connection) {
            return RemoteSingle.createSingle(this.parent(), connection, this.getIdentifier());
        }
    }

    private static final class Remote
    extends AbstractRemote {
        Remote(AbstractClientHistory parent, AbstractClientConnection<ShardBackendInfo> connection, LocalHistoryIdentifier identifier) {
            super(parent, connection, identifier);
        }

        @Override
        AbstractProxyTransaction doCreateTransactionProxy(AbstractClientConnection<ShardBackendInfo> connection, TransactionIdentifier txId, boolean snapshotOnly, boolean isDone) {
            return new RemoteProxyTransaction(this, txId, snapshotOnly, true, isDone);
        }

        @Override
        ProxyHistory createSuccessor(AbstractClientConnection<ShardBackendInfo> connection) {
            return Remote.createClient(this.parent(), connection, this.getIdentifier());
        }
    }

    private static final class LocalSingle
    extends AbstractLocal {
        LocalSingle(AbstractClientHistory parent, AbstractClientConnection<ShardBackendInfo> connection, LocalHistoryIdentifier identifier, ReadOnlyDataTree dataTree) {
            super(parent, connection, identifier, dataTree);
        }

        @Override
        AbstractProxyTransaction doCreateTransactionProxy(AbstractClientConnection<ShardBackendInfo> connection, TransactionIdentifier txId, boolean snapshotOnly, boolean isDone) {
            DataTreeSnapshot snapshot = this.takeSnapshot();
            return snapshotOnly ? new LocalReadOnlyProxyTransaction((ProxyHistory)this, txId, snapshot) : new LocalReadWriteProxyTransaction((ProxyHistory)this, txId, snapshot);
        }

        @Override
        ProxyHistory createSuccessor(AbstractClientConnection<ShardBackendInfo> connection) {
            return LocalSingle.createSingle(this.parent(), connection, this.getIdentifier());
        }
    }

    private static final class Local
    extends AbstractLocal {
        private static final AtomicReferenceFieldUpdater<Local, LocalReadWriteProxyTransaction> LAST_SEALED_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Local.class, LocalReadWriteProxyTransaction.class, "lastSealed");
        private LocalReadWriteProxyTransaction lastOpen;
        private volatile LocalReadWriteProxyTransaction lastSealed;

        Local(AbstractClientHistory parent, AbstractClientConnection<ShardBackendInfo> connection, LocalHistoryIdentifier identifier, ReadOnlyDataTree dataTree) {
            super(parent, connection, identifier, dataTree);
        }

        @Override
        AbstractProxyTransaction doCreateTransactionProxy(AbstractClientConnection<ShardBackendInfo> connection, TransactionIdentifier txId, boolean snapshotOnly, boolean isDone) {
            Preconditions.checkState((this.lastOpen == null ? 1 : 0) != 0, (String)"Proxy %s has %s currently open", (Object)this, (Object)this.lastOpen);
            if (isDone) {
                return snapshotOnly ? new LocalReadOnlyProxyTransaction((ProxyHistory)this, txId) : new LocalReadWriteProxyTransaction((ProxyHistory)this, txId);
            }
            LocalReadWriteProxyTransaction localSealed = this.lastSealed;
            DataTreeSnapshot baseSnapshot = localSealed != null ? localSealed.getSnapshot() : this.takeSnapshot();
            if (snapshotOnly) {
                return new LocalReadOnlyProxyTransaction((ProxyHistory)this, txId, baseSnapshot);
            }
            this.lastOpen = new LocalReadWriteProxyTransaction((ProxyHistory)this, txId, baseSnapshot);
            LOG.debug("Proxy {} open transaction {}", (Object)this, (Object)this.lastOpen);
            return this.lastOpen;
        }

        @Override
        ProxyHistory createSuccessor(AbstractClientConnection<ShardBackendInfo> connection) {
            return Local.createClient(this.parent(), connection, this.getIdentifier());
        }

        @Override
        void onTransactionAborted(AbstractProxyTransaction tx) {
            if (tx.equals(this.lastOpen)) {
                this.lastOpen = null;
            }
        }

        @Override
        void onTransactionCompleted(AbstractProxyTransaction tx) {
            Verify.verify((boolean)(tx instanceof LocalProxyTransaction));
            if (tx instanceof LocalReadWriteProxyTransaction && LAST_SEALED_UPDATER.compareAndSet(this, (LocalReadWriteProxyTransaction)tx, null)) {
                LOG.debug("Completed last sealed transaction {}", (Object)tx);
            }
        }

        @Override
        void onTransactionSealed(AbstractProxyTransaction tx) {
            Preconditions.checkState((boolean)tx.equals(this.lastOpen));
            this.lastSealed = this.lastOpen;
            this.lastOpen = null;
        }
    }

    private static abstract class AbstractRemote
    extends ProxyHistory {
        AbstractRemote(AbstractClientHistory parent, AbstractClientConnection<ShardBackendInfo> connection, LocalHistoryIdentifier identifier) {
            super(parent, connection, identifier);
        }
    }

    private static abstract class AbstractLocal
    extends ProxyHistory {
        private final ReadOnlyDataTree dataTree;

        AbstractLocal(AbstractClientHistory parent, AbstractClientConnection<ShardBackendInfo> connection, LocalHistoryIdentifier identifier, ReadOnlyDataTree dataTree) {
            super(parent, connection, identifier);
            this.dataTree = Objects.requireNonNull(dataTree);
        }

        final DataTreeSnapshot takeSnapshot() {
            return this.dataTree.takeSnapshot();
        }
    }
}

