/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.primitives.UnsignedLong;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.commands.AbstractReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ClosedTransactionException;
import org.opendaylight.controller.cluster.access.commands.CommitLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.DeadTransactionException;
import org.opendaylight.controller.cluster.access.commands.IncrementTransactionSequenceRequest;
import org.opendaylight.controller.cluster.access.commands.LocalHistorySuccess;
import org.opendaylight.controller.cluster.access.commands.OutOfOrderRequestException;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionPurgeResponse;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionSuccess;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.FrontendTransaction;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractFrontendHistory
implements Identifiable<LocalHistoryIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFrontendHistory.class);
    private final Map<TransactionIdentifier, FrontendTransaction> transactions = new HashMap<TransactionIdentifier, FrontendTransaction>();
    private final RangeSet<UnsignedLong> purgedTransactions;
    private final String persistenceId;
    private final ShardDataTree tree;
    private Map<UnsignedLong, Boolean> closedTransactions;

    AbstractFrontendHistory(String persistenceId, ShardDataTree tree, Map<UnsignedLong, Boolean> closedTransactions, RangeSet<UnsignedLong> purgedTransactions) {
        this.persistenceId = Objects.requireNonNull(persistenceId);
        this.tree = Objects.requireNonNull(tree);
        this.closedTransactions = Objects.requireNonNull(closedTransactions);
        this.purgedTransactions = Objects.requireNonNull(purgedTransactions);
    }

    final String persistenceId() {
        return this.persistenceId;
    }

    final long readTime() {
        return this.tree.readTime();
    }

    final @Nullable TransactionSuccess<?> handleTransactionRequest(TransactionRequest<?> request, RequestEnvelope envelope, long now) throws RequestException {
        Optional<TransactionSuccess<?>> maybeReplay;
        if (request instanceof TransactionPurgeRequest) {
            return this.handleTransactionPurgeRequest(request, envelope, now);
        }
        TransactionIdentifier id = (TransactionIdentifier)request.getTarget();
        UnsignedLong ul = UnsignedLong.fromLongBits((long)id.getTransactionId());
        if (this.purgedTransactions.contains((Comparable)ul)) {
            LOG.warn("{}: Request {} is contained purged transactions {}", new Object[]{this.persistenceId, request, this.purgedTransactions});
            throw new DeadTransactionException(this.purgedTransactions);
        }
        Boolean closed = this.closedTransactions.get(ul);
        if (closed != null) {
            boolean successful = closed;
            LOG.debug("{}: Request {} refers to a {} transaction", new Object[]{this.persistenceId, request, successful ? "successful" : "failed"});
            throw new ClosedTransactionException(successful);
        }
        FrontendTransaction tx = this.transactions.get(id);
        if (tx == null) {
            if (request.getSequence() != 0L) {
                LOG.warn("{}: no transaction state present, unexpected request {}", (Object)this.persistenceId(), request);
                throw new OutOfOrderRequestException(0L);
            }
            tx = this.createTransaction(request, id);
            this.transactions.put(id, tx);
        } else if (!(request instanceof IncrementTransactionSequenceRequest) && (maybeReplay = tx.replaySequence(request.getSequence())).isPresent()) {
            TransactionSuccess<?> replay = maybeReplay.get();
            LOG.debug("{}: envelope {} replaying response {}", new Object[]{this.persistenceId(), envelope, replay});
            return replay;
        }
        return tx.handleRequest(request, envelope, now);
    }

    private TransactionSuccess<?> handleTransactionPurgeRequest(TransactionRequest<?> request, RequestEnvelope envelope, long now) {
        TransactionIdentifier id = (TransactionIdentifier)request.getTarget();
        UnsignedLong ul = UnsignedLong.fromLongBits((long)id.getTransactionId());
        if (this.purgedTransactions.contains((Comparable)ul)) {
            LOG.debug("{}: transaction {} already purged", (Object)this.persistenceId, (Object)id);
            return new TransactionPurgeResponse(id, request.getSequence());
        }
        if (this.closedTransactions.containsKey(ul)) {
            this.tree.purgeTransaction(id, () -> {
                this.closedTransactions.remove(ul);
                if (this.closedTransactions.isEmpty()) {
                    this.closedTransactions = ImmutableMap.of();
                }
                this.purgedTransactions.add(Range.closedOpen((Comparable)ul, (Comparable)UnsignedLong.ONE.plus(ul)));
                LOG.debug("{}: finished purging inherited transaction {}", (Object)this.persistenceId(), (Object)id);
                envelope.sendSuccess((RequestSuccess)new TransactionPurgeResponse(id, request.getSequence()), this.readTime() - now);
            });
            return null;
        }
        FrontendTransaction tx = this.transactions.get(id);
        if (tx == null) {
            LOG.warn("{}: transaction {} not tracked in {}, but not present in active transactions", new Object[]{this.persistenceId, id, this.purgedTransactions});
            this.purgedTransactions.add(Range.closedOpen((Comparable)ul, (Comparable)UnsignedLong.ONE.plus(ul)));
            return new TransactionPurgeResponse(id, request.getSequence());
        }
        this.tree.purgeTransaction(id, () -> {
            this.purgedTransactions.add(Range.closedOpen((Comparable)ul, (Comparable)UnsignedLong.ONE.plus(ul)));
            this.transactions.remove(id);
            LOG.debug("{}: finished purging transaction {}", (Object)this.persistenceId(), (Object)id);
            envelope.sendSuccess((RequestSuccess)new TransactionPurgeResponse(id, request.getSequence()), this.readTime() - now);
        });
        return null;
    }

    final void destroy(long sequence, RequestEnvelope envelope, long now) {
        LOG.debug("{}: closing history {}", (Object)this.persistenceId(), this.getIdentifier());
        this.tree.closeTransactionChain((LocalHistoryIdentifier)this.getIdentifier(), () -> envelope.sendSuccess((RequestSuccess)new LocalHistorySuccess((LocalHistoryIdentifier)this.getIdentifier(), sequence), this.readTime() - now));
    }

    final void purge(long sequence, RequestEnvelope envelope, long now) {
        LOG.debug("{}: purging history {}", (Object)this.persistenceId(), this.getIdentifier());
        this.tree.purgeTransactionChain((LocalHistoryIdentifier)this.getIdentifier(), () -> envelope.sendSuccess((RequestSuccess)new LocalHistorySuccess((LocalHistoryIdentifier)this.getIdentifier(), sequence), this.readTime() - now));
    }

    final void retire() {
        this.transactions.values().forEach(FrontendTransaction::retire);
        this.tree.removeTransactionChain((LocalHistoryIdentifier)this.getIdentifier());
    }

    private FrontendTransaction createTransaction(TransactionRequest<?> request, TransactionIdentifier id) {
        if (request instanceof CommitLocalTransactionRequest) {
            LOG.debug("{}: allocating new ready transaction {}", (Object)this.persistenceId(), (Object)id);
            this.tree.getStats().incrementReadWriteTransactionCount();
            return this.createReadyTransaction(id, ((CommitLocalTransactionRequest)request).getModification());
        }
        if (request instanceof AbstractReadTransactionRequest && ((AbstractReadTransactionRequest)request).isSnapshotOnly()) {
            LOG.debug("{}: allocating new open snapshot {}", (Object)this.persistenceId(), (Object)id);
            this.tree.getStats().incrementReadOnlyTransactionCount();
            return this.createOpenSnapshot(id);
        }
        LOG.debug("{}: allocating new open transaction {}", (Object)this.persistenceId(), (Object)id);
        this.tree.getStats().incrementReadWriteTransactionCount();
        return this.createOpenTransaction(id);
    }

    abstract FrontendTransaction createOpenSnapshot(TransactionIdentifier var1);

    abstract FrontendTransaction createOpenTransaction(TransactionIdentifier var1);

    abstract FrontendTransaction createReadyTransaction(TransactionIdentifier var1, DataTreeModification var2);

    abstract ShardDataTreeCohort createFailedCohort(TransactionIdentifier var1, DataTreeModification var2, Exception var3);

    abstract ShardDataTreeCohort createReadyCohort(TransactionIdentifier var1, DataTreeModification var2, Optional<SortedSet<String>> var3);

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("identifier", this.getIdentifier()).add("persistenceId", (Object)this.persistenceId).add("transactions", this.transactions).toString();
    }
}

