/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.FutureCallback;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardCommitCoordinator;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;

final class CohortEntry {
    private final ReadWriteShardDataTreeTransaction transaction;
    private final TransactionIdentifier transactionId;
    private final short clientVersion;
    private RuntimeException lastBatchedModificationsException;
    private int totalBatchedModificationsReceived;
    private int totalOperationsProcessed;
    private ShardDataTreeCohort cohort;
    private boolean doImmediateCommit;
    private ActorRef replySender;
    private Shard shard;

    private CohortEntry(ReadWriteShardDataTreeTransaction transaction, short clientVersion) {
        this.cohort = null;
        this.transaction = Objects.requireNonNull(transaction);
        this.transactionId = transaction.getIdentifier();
        this.clientVersion = clientVersion;
    }

    private CohortEntry(ShardDataTreeCohort cohort, short clientVersion) {
        this.cohort = Objects.requireNonNull(cohort);
        this.transactionId = (TransactionIdentifier)cohort.getIdentifier();
        this.transaction = null;
        this.clientVersion = clientVersion;
    }

    static CohortEntry createOpen(ReadWriteShardDataTreeTransaction transaction, short clientVersion) {
        return new CohortEntry(transaction, clientVersion);
    }

    static CohortEntry createReady(ShardDataTreeCohort cohort, short clientVersion) {
        return new CohortEntry(cohort, clientVersion);
    }

    TransactionIdentifier getTransactionId() {
        return this.transactionId;
    }

    short getClientVersion() {
        return this.clientVersion;
    }

    boolean isFailed() {
        return this.cohort != null && this.cohort.isFailed();
    }

    DataTreeModification getDataTreeModification() {
        return this.cohort.getDataTreeModification();
    }

    ReadWriteShardDataTreeTransaction getTransaction() {
        return this.transaction;
    }

    int getTotalBatchedModificationsReceived() {
        return this.totalBatchedModificationsReceived;
    }

    int getTotalOperationsProcessed() {
        return this.totalOperationsProcessed;
    }

    RuntimeException getLastBatchedModificationsException() {
        return this.lastBatchedModificationsException;
    }

    void applyModifications(List<Modification> modifications) {
        ++this.totalBatchedModificationsReceived;
        if (this.lastBatchedModificationsException == null) {
            this.totalOperationsProcessed += modifications.size();
            for (Modification modification : modifications) {
                try {
                    modification.apply((DataTreeModification)this.transaction.getSnapshot());
                }
                catch (RuntimeException e) {
                    this.lastBatchedModificationsException = e;
                    throw e;
                }
            }
        }
    }

    void canCommit(FutureCallback<Void> callback) {
        this.cohort.canCommit(callback);
    }

    void preCommit(FutureCallback<DataTreeCandidate> callback) {
        this.cohort.preCommit(callback);
    }

    void commit(FutureCallback<UnsignedLong> callback) {
        this.cohort.commit(callback);
    }

    void abort(FutureCallback<Void> callback) {
        this.cohort.abort(callback);
    }

    void ready(Optional<SortedSet<String>> participatingShardNames, ShardCommitCoordinator.CohortDecorator cohortDecorator) {
        Preconditions.checkState((this.cohort == null ? 1 : 0) != 0, (Object)"cohort was already set");
        this.cohort = this.transaction.ready(participatingShardNames);
        if (cohortDecorator != null) {
            this.cohort = cohortDecorator.decorate((Identifier)this.transactionId, this.cohort);
        }
    }

    boolean isSealed() {
        return this.cohort != null;
    }

    Optional<SortedSet<String>> getParticipatingShardNames() {
        return this.cohort != null ? this.cohort.getParticipatingShardNames() : Optional.empty();
    }

    boolean isDoImmediateCommit() {
        return this.doImmediateCommit;
    }

    void setDoImmediateCommit(boolean doImmediateCommit) {
        this.doImmediateCommit = doImmediateCommit;
    }

    ActorRef getReplySender() {
        return this.replySender;
    }

    void setReplySender(ActorRef replySender) {
        this.replySender = replySender;
    }

    Shard getShard() {
        return this.shard;
    }

    void setShard(Shard shard) {
        this.shard = shard;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CohortEntry [transactionId=").append(this.transactionId).append(", doImmediateCommit=").append(this.doImmediateCommit).append("]");
        return builder.toString();
    }
}

