/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.annotations.VisibleForTesting;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextIntrospector;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class DatastoreContextIntrospectorFactory {
    private final DOMSchemaService schemaService;
    private final ClassLoadingStrategy classLoadingStrategy;

    public DatastoreContextIntrospectorFactory(DOMSchemaService schemaService, ClassLoadingStrategy classLoadingStrategy) {
        this.schemaService = schemaService;
        this.classLoadingStrategy = classLoadingStrategy;
    }

    public DatastoreContextIntrospector newInstance(LogicalDatastoreType datastoreType) {
        return new DatastoreContextIntrospector(DatastoreContext.newBuilder().logicalStoreType(datastoreType).tempFileDirectory("./data").build(), this.newBindingSerializer());
    }

    @VisibleForTesting
    DatastoreContextIntrospector newInstance(DatastoreContext context) {
        return new DatastoreContextIntrospector(context, this.newBindingSerializer());
    }

    private BindingNormalizedNodeSerializer newBindingSerializer() {
        BindingNormalizedNodeCodecRegistry codecRegistry = new BindingNormalizedNodeCodecRegistry(BindingRuntimeContext.create((ClassLoadingStrategy)this.classLoadingStrategy, (SchemaContext)this.schemaService.getGlobalContext()));
        return codecRegistry;
    }
}

