/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.util.Map;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.DatastoreContextIntrospector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreContextPropertiesUpdater
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreContextPropertiesUpdater.class);
    private final DatastoreContextIntrospector introspector;
    private Listener listener;

    public DatastoreContextPropertiesUpdater(DatastoreContextIntrospector introspector, Map<String, Object> props) {
        this.introspector = introspector;
        this.update(props);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void update(Map<String, Object> properties) {
        LOG.debug("Overlaying settings: {}", properties);
        if (this.introspector.update(properties) && this.listener != null) {
            this.listener.onDatastoreContextUpdated(this.introspector.newContextFactory());
        }
    }

    @Override
    public void close() {
        this.listener = null;
    }

    public static interface Listener {
        public void onDatastoreContextUpdated(DatastoreContextFactory var1);
    }
}

