/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.FrontendClientMetadataBuilder;
import org.opendaylight.controller.cluster.datastore.LeaderFrontendState;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendClientMetadata;
import org.opendaylight.controller.cluster.datastore.persisted.FrontendShardDataTreeSnapshotMetadata;
import org.opendaylight.yangtools.concepts.Builder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FrontendMetadata
extends ShardDataTreeMetadata<FrontendShardDataTreeSnapshotMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(FrontendMetadata.class);
    private final Map<FrontendIdentifier, FrontendClientMetadataBuilder> clients = new HashMap<FrontendIdentifier, FrontendClientMetadataBuilder>();
    private final String shardName;

    FrontendMetadata(String shardName) {
        this.shardName = Objects.requireNonNull(shardName);
    }

    @Override
    Class<FrontendShardDataTreeSnapshotMetadata> getSupportedType() {
        return FrontendShardDataTreeSnapshotMetadata.class;
    }

    @Override
    void reset() {
        LOG.debug("{}: clearing clients {}", (Object)this.shardName, this.clients);
        this.clients.clear();
    }

    @Override
    void doApplySnapshot(FrontendShardDataTreeSnapshotMetadata snapshot) {
        LOG.debug("{}: applying snapshot {} over clients {}", new Object[]{this.shardName, snapshot, this.clients});
        this.clients.clear();
        for (FrontendClientMetadata m : snapshot.getClients()) {
            LOG.debug("{}: applying metadata {}", (Object)this.shardName, (Object)m);
            FrontendClientMetadataBuilder b = FrontendClientMetadataBuilder.of(this.shardName, m);
            FrontendIdentifier client = m.getIdentifier().getFrontendId();
            LOG.debug("{}: client {} updated to {}", new Object[]{this.shardName, client, b});
            this.clients.put(client, b);
        }
    }

    @Override
    FrontendShardDataTreeSnapshotMetadata toSnapshot() {
        return new FrontendShardDataTreeSnapshotMetadata(Collections2.transform(this.clients.values(), Builder::build));
    }

    private FrontendClientMetadataBuilder ensureClient(ClientIdentifier id) {
        FrontendClientMetadataBuilder existing = this.clients.get(id.getFrontendId());
        if (existing != null && id.equals((Object)existing.getIdentifier())) {
            return existing;
        }
        FrontendClientMetadataBuilder.Enabled client = new FrontendClientMetadataBuilder.Enabled(this.shardName, id);
        FrontendClientMetadataBuilder previous = this.clients.put(id.getFrontendId(), client);
        if (previous != null) {
            LOG.debug("{}: Replaced client {} with {}", new Object[]{this.shardName, previous, client});
        } else {
            LOG.debug("{}: Added client {}", (Object)this.shardName, (Object)client);
        }
        return client;
    }

    @Override
    void onHistoryCreated(LocalHistoryIdentifier historyId) {
        this.ensureClient(historyId.getClientId()).onHistoryCreated(historyId);
    }

    @Override
    void onHistoryClosed(LocalHistoryIdentifier historyId) {
        this.ensureClient(historyId.getClientId()).onHistoryClosed(historyId);
    }

    @Override
    void onHistoryPurged(LocalHistoryIdentifier historyId) {
        this.ensureClient(historyId.getClientId()).onHistoryPurged(historyId);
    }

    @Override
    void onTransactionAborted(TransactionIdentifier txId) {
        this.ensureClient(txId.getHistoryId().getClientId()).onTransactionAborted(txId);
    }

    @Override
    void onTransactionCommitted(TransactionIdentifier txId) {
        this.ensureClient(txId.getHistoryId().getClientId()).onTransactionCommitted(txId);
    }

    @Override
    void onTransactionPurged(TransactionIdentifier txId) {
        this.ensureClient(txId.getHistoryId().getClientId()).onTransactionPurged(txId);
    }

    @NonNull Map<FrontendIdentifier, LeaderFrontendState> toLeaderState(@NonNull Shard shard) {
        return new HashMap<FrontendIdentifier, LeaderFrontendState>(Maps.transformValues(this.clients, meta -> meta.toLeaderState(shard)));
    }

    void disableTracking(ClientIdentifier clientId) {
        FrontendIdentifier frontendId = clientId.getFrontendId();
        FrontendClientMetadataBuilder client = this.clients.get(frontendId);
        if (client == null) {
            LOG.debug("{}: disableTracking {} does not match any client, pre-disabling client.", (Object)this.shardName, (Object)clientId);
            this.clients.put(frontendId, new FrontendClientMetadataBuilder.Disabled(this.shardName, clientId));
            return;
        }
        if (!clientId.equals((Object)client.getIdentifier())) {
            LOG.debug("{}: disableTracking {} does not match client {}, ignoring", new Object[]{this.shardName, clientId, client});
            return;
        }
        if (client instanceof FrontendClientMetadataBuilder.Disabled) {
            LOG.debug("{}: client {} is has already disabled tracking", (Object)this.shardName, (Object)client);
            return;
        }
        Verify.verify((boolean)this.clients.replace(frontendId, client, new FrontendClientMetadataBuilder.Disabled(this.shardName, clientId)));
    }

    ImmutableSet<ClientIdentifier> getClients() {
        return (ImmutableSet)this.clients.values().stream().map(FrontendClientMetadataBuilder::getIdentifier).collect(ImmutableSet.toImmutableSet());
    }
}

