/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.LocalThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.LocalTransactionFactory;
import org.opendaylight.controller.cluster.datastore.TransactionChainProxy;
import org.opendaylight.mdsal.dom.spi.store.AbstractSnapshotBackedTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.SnapshotBackedWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ReadOnlyDataTree;

final class LocalTransactionChain
extends AbstractSnapshotBackedTransactionChain<TransactionIdentifier>
implements LocalTransactionFactory {
    private static final Throwable ABORTED = new Throwable("Transaction aborted");
    private final TransactionChainProxy parent;
    private final ActorSelection leader;
    private final ReadOnlyDataTree tree;

    LocalTransactionChain(TransactionChainProxy parent, ActorSelection leader, ReadOnlyDataTree tree) {
        this.parent = Objects.requireNonNull(parent);
        this.leader = Objects.requireNonNull(leader);
        this.tree = Objects.requireNonNull(tree);
    }

    ReadOnlyDataTree getDataTree() {
        return this.tree;
    }

    protected TransactionIdentifier nextTransactionIdentifier() {
        throw new UnsupportedOperationException();
    }

    protected boolean getDebugTransactions() {
        return false;
    }

    protected DataTreeSnapshot takeSnapshot() {
        return this.tree.takeSnapshot();
    }

    protected DOMStoreThreePhaseCommitCohort createCohort(SnapshotBackedWriteTransaction<TransactionIdentifier> transaction, DataTreeModification modification, Exception operationError) {
        return new LocalChainThreePhaseCommitCohort(transaction, modification, operationError);
    }

    @Override
    public DOMStoreReadTransaction newReadOnlyTransaction(TransactionIdentifier identifier) {
        return super.newReadOnlyTransaction((Object)identifier);
    }

    @Override
    public DOMStoreReadWriteTransaction newReadWriteTransaction(TransactionIdentifier identifier) {
        return super.newReadWriteTransaction((Object)identifier);
    }

    @Override
    public DOMStoreWriteTransaction newWriteOnlyTransaction(TransactionIdentifier identifier) {
        return super.newWriteOnlyTransaction((Object)identifier);
    }

    @Override
    public LocalThreePhaseCommitCohort onTransactionReady(DOMStoreWriteTransaction tx, Exception operationError) {
        Preconditions.checkArgument((boolean)(tx instanceof SnapshotBackedWriteTransaction));
        if (operationError != null) {
            return new LocalChainThreePhaseCommitCohort((SnapshotBackedWriteTransaction<TransactionIdentifier>)((SnapshotBackedWriteTransaction)tx), operationError);
        }
        try {
            return (LocalThreePhaseCommitCohort)tx.ready();
        }
        catch (Exception e) {
            return new LocalChainThreePhaseCommitCohort((SnapshotBackedWriteTransaction<TransactionIdentifier>)((SnapshotBackedWriteTransaction)tx), e);
        }
    }

    private class LocalChainThreePhaseCommitCohort
    extends LocalThreePhaseCommitCohort {
        protected LocalChainThreePhaseCommitCohort(SnapshotBackedWriteTransaction<TransactionIdentifier> transaction, DataTreeModification modification, Exception operationError) {
            super(LocalTransactionChain.this.parent.getActorUtils(), LocalTransactionChain.this.leader, transaction, modification, operationError);
        }

        protected LocalChainThreePhaseCommitCohort(SnapshotBackedWriteTransaction<TransactionIdentifier> transaction, Exception operationError) {
            super(LocalTransactionChain.this.parent.getActorUtils(), LocalTransactionChain.this.leader, transaction, operationError);
        }

        @Override
        protected void transactionAborted(SnapshotBackedWriteTransaction<TransactionIdentifier> transaction) {
            LocalTransactionChain.this.onTransactionFailed(transaction, ABORTED);
        }

        @Override
        protected void transactionCommitted(SnapshotBackedWriteTransaction<TransactionIdentifier> transaction) {
            LocalTransactionChain.this.onTransactionCommited(transaction);
        }
    }
}

