/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import akka.dispatch.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Optional;
import java.util.SortedSet;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTransactionContext;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.messages.AbstractRead;
import org.opendaylight.mdsal.common.api.DataStoreUnavailableException;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Future;

final class NoOpTransactionContext
extends AbstractTransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(NoOpTransactionContext.class);
    private final Throwable failure;

    NoOpTransactionContext(Throwable failure, TransactionIdentifier identifier) {
        super(identifier);
        this.failure = failure;
    }

    @Override
    public void closeTransaction() {
        LOG.debug("NoOpTransactionContext {} closeTransaction called", (Object)this.getIdentifier());
    }

    @Override
    public Future<Object> directCommit(Boolean havePermit) {
        LOG.debug("Tx {} directCommit called, failure", (Object)this.getIdentifier(), (Object)this.failure);
        return Futures.failed((Throwable)this.failure);
    }

    @Override
    public Future<ActorSelection> readyTransaction(Boolean havePermit, Optional<SortedSet<String>> participatingShardNamess) {
        LOG.debug("Tx {} readyTransaction called, failure", (Object)this.getIdentifier(), (Object)this.failure);
        return Futures.failed((Throwable)this.failure);
    }

    @Override
    public <T> void executeRead(AbstractRead<T> readCmd, SettableFuture<T> proxyFuture, Boolean havePermit) {
        LOG.debug("Tx {} executeRead {} called path = {}", new Object[]{this.getIdentifier(), readCmd.getClass().getSimpleName(), readCmd.getPath()});
        Throwable t = this.failure instanceof NoShardLeaderException ? new DataStoreUnavailableException(this.failure.getMessage(), this.failure) : this.failure;
        proxyFuture.setException((Throwable)new ReadFailedException("Error executeRead " + readCmd.getClass().getSimpleName() + " for path " + readCmd.getPath(), t, new RpcError[0]));
    }

    @Override
    public void executeDelete(YangInstanceIdentifier path, Boolean havePermit) {
        LOG.debug("Tx {} executeDelete called path = {}", (Object)this.getIdentifier(), (Object)path);
    }

    @Override
    public void executeMerge(YangInstanceIdentifier path, NormalizedNode<?, ?> data, Boolean havePermit) {
        LOG.debug("Tx {} executeMerge called path = {}", (Object)this.getIdentifier(), (Object)path);
    }

    @Override
    public void executeWrite(YangInstanceIdentifier path, NormalizedNode<?, ?> data, Boolean havePermit) {
        LOG.debug("Tx {} executeWrite called path = {}", (Object)this.getIdentifier(), (Object)path);
    }
}

