/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.compat;

import com.google.common.base.Optional;
import com.google.common.collect.ForwardingObject;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.md.sal.common.api.MappingCheckedFuture;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.sal.core.compat.ReadFailedExceptionAdapter;
import org.opendaylight.controller.sal.core.spi.data.DOMStore;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Deprecated(forRemoval=true)
public class LegacyDOMStoreAdapter
extends ForwardingObject
implements DOMStore,
AutoCloseable {
    private final DistributedDataStoreInterface delegate;

    public LegacyDOMStoreAdapter(DistributedDataStoreInterface delegate) {
        this.delegate = delegate;
    }

    public org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction newReadOnlyTransaction() {
        return new DOMStoreTransactionAdapter(this.delegate().newReadOnlyTransaction());
    }

    public org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction newWriteOnlyTransaction() {
        return new DOMStoreTransactionAdapter(this.delegate().newWriteOnlyTransaction());
    }

    public DOMStoreReadWriteTransaction newReadWriteTransaction() {
        return new DOMStoreTransactionAdapter(this.delegate().newReadWriteTransaction());
    }

    public DOMStoreTransactionChain createTransactionChain() {
        final org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain delegateChain = this.delegate().createTransactionChain();
        return new DOMStoreTransactionChain(){

            public org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction newReadOnlyTransaction() {
                return new DOMStoreTransactionAdapter(delegateChain.newReadOnlyTransaction());
            }

            public org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction newWriteOnlyTransaction() {
                return new DOMStoreTransactionAdapter(delegateChain.newWriteOnlyTransaction());
            }

            public DOMStoreReadWriteTransaction newReadWriteTransaction() {
                return new DOMStoreTransactionAdapter(delegateChain.newReadWriteTransaction());
            }

            public void close() {
                delegateChain.close();
            }
        };
    }

    @Override
    public void close() {
    }

    protected DistributedDataStoreInterface delegate() {
        return this.delegate;
    }

    private static class DOMStoreTransactionAdapter
    implements DOMStoreReadWriteTransaction {
        private final DOMStoreReadTransaction readDelegate;
        private final DOMStoreWriteTransaction writeDelegate;
        private final Object identifier;

        DOMStoreTransactionAdapter(@NonNull DOMStoreReadTransaction readDelegate) {
            this.readDelegate = Objects.requireNonNull(readDelegate);
            this.identifier = readDelegate.getIdentifier();
            this.writeDelegate = null;
        }

        DOMStoreTransactionAdapter(@NonNull DOMStoreWriteTransaction writeDelegate) {
            this.writeDelegate = Objects.requireNonNull(writeDelegate);
            this.identifier = writeDelegate.getIdentifier();
            this.readDelegate = null;
        }

        DOMStoreTransactionAdapter(@NonNull org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction rwDelegate) {
            this.readDelegate = (DOMStoreReadTransaction)Objects.requireNonNull(rwDelegate);
            this.writeDelegate = rwDelegate;
            this.identifier = this.readDelegate.getIdentifier();
        }

        public Object getIdentifier() {
            return this.identifier;
        }

        public void close() {
            if (this.writeDelegate != null) {
                this.writeDelegate.close();
            } else {
                this.readDelegate.close();
            }
        }

        public void write(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
            this.writeDelegate.write(path, data);
        }

        public void merge(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
            this.writeDelegate.merge(path, data);
        }

        public void delete(YangInstanceIdentifier path) {
            this.writeDelegate.delete(path);
        }

        public DOMStoreThreePhaseCommitCohort ready() {
            final org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort cohort = this.writeDelegate.ready();
            return new DOMStoreThreePhaseCommitCohort(){

                public ListenableFuture<Boolean> canCommit() {
                    return cohort.canCommit();
                }

                public ListenableFuture<Void> preCommit() {
                    return cohort.preCommit();
                }

                public ListenableFuture<Void> commit() {
                    return cohort.commit();
                }

                public ListenableFuture<Void> abort() {
                    return cohort.abort();
                }
            };
        }

        public CheckedFuture<Optional<NormalizedNode<?, ?>>, ReadFailedException> read(YangInstanceIdentifier path) {
            return MappingCheckedFuture.create((ListenableFuture)this.readDelegate.read(path).transform(Optional::fromJavaUtil, MoreExecutors.directExecutor()), (Function)ReadFailedExceptionAdapter.INSTANCE);
        }

        public CheckedFuture<Boolean, ReadFailedException> exists(YangInstanceIdentifier path) {
            return MappingCheckedFuture.create((ListenableFuture)this.readDelegate.exists(path), (Function)ReadFailedExceptionAdapter.INSTANCE);
        }
    }
}

