/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.controller.cluster.datastore.persisted.ChunkedInputStream;
import org.opendaylight.yangtools.concepts.Immutable;

@NonNullByDefault
final class ChunkedByteArray
implements Immutable {
    private final ImmutableList<byte[]> chunks;
    private final int size;

    ChunkedByteArray(int size, ImmutableList<byte[]> chunks) {
        this.size = size;
        this.chunks = Objects.requireNonNull(chunks);
    }

    static ChunkedByteArray readFrom(ObjectInput in, int size, int chunkSize) throws IOException {
        byte[] buffer;
        ArrayList<byte[]> chunks = new ArrayList<byte[]>(ChunkedByteArray.requiredChunks(size, chunkSize));
        int remaining = size;
        do {
            buffer = new byte[Math.min(remaining, chunkSize)];
            in.readFully(buffer);
            chunks.add(buffer);
        } while ((remaining -= buffer.length) != 0);
        return new ChunkedByteArray(size, (ImmutableList<byte[]>)ImmutableList.copyOf(chunks));
    }

    int size() {
        return this.size;
    }

    ChunkedInputStream openStream() {
        return new ChunkedInputStream(this.size, (Iterator<byte[]>)this.chunks.iterator());
    }

    void copyTo(DataOutput output) throws IOException {
        for (byte[] chunk : this.chunks) {
            output.write(chunk, 0, chunk.length);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("size", this.size).add("chunkCount", this.chunks.size()).toString();
    }

    ImmutableList<byte[]> getChunks() {
        return this.chunks;
    }

    private static int requiredChunks(int size, int chunkSize) {
        int div = size / chunkSize;
        return size % chunkSize == 0 ? div : div + 1;
    }
}

