/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.sharding.DistributedShardChangePublisher;
import org.opendaylight.controller.cluster.sharding.DistributedShardModificationFactory;
import org.opendaylight.controller.cluster.sharding.DistributedShardModificationFactoryBuilder;
import org.opendaylight.controller.cluster.sharding.ShardProxyProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShard;
import org.opendaylight.mdsal.dom.spi.shard.ChildShardContext;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardProducer;
import org.opendaylight.mdsal.dom.spi.shard.ForeignShardModificationContext;
import org.opendaylight.mdsal.dom.spi.shard.ReadableWriteableDOMDataTreeShard;
import org.opendaylight.mdsal.dom.spi.shard.SubshardProducerSpecification;
import org.opendaylight.mdsal.dom.spi.shard.WriteableDOMDataTreeShard;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DistributedShardFrontend
implements ReadableWriteableDOMDataTreeShard {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedShardFrontend.class);
    private final DataStoreClient client;
    private final DOMDataTreeIdentifier shardRoot;
    private final @GuardedBy(value={"this"}) Map<DOMDataTreeIdentifier, ChildShardContext> childShards = new HashMap<DOMDataTreeIdentifier, ChildShardContext>();
    private final @GuardedBy(value={"this"}) List<ShardProxyProducer> producers = new ArrayList<ShardProxyProducer>();
    private final DistributedShardChangePublisher publisher;

    DistributedShardFrontend(AbstractDataStore distributedDataStore, DataStoreClient client, DOMDataTreeIdentifier shardRoot) {
        this.client = Objects.requireNonNull(client);
        this.shardRoot = Objects.requireNonNull(shardRoot);
        this.publisher = new DistributedShardChangePublisher(client, Objects.requireNonNull(distributedDataStore), shardRoot, this.childShards);
    }

    public synchronized DOMDataTreeShardProducer createProducer(Collection<DOMDataTreeIdentifier> paths) {
        for (DOMDataTreeIdentifier prodPrefix : paths) {
            Preconditions.checkArgument((boolean)this.shardRoot.contains(prodPrefix), (String)"Prefix %s is not contained under shard root", (Object)prodPrefix, paths);
        }
        ShardProxyProducer ret = new ShardProxyProducer(this.shardRoot, paths, this.client, this.createModificationFactory(paths));
        this.producers.add(ret);
        return ret;
    }

    public synchronized void onChildAttached(DOMDataTreeIdentifier prefix, DOMDataTreeShard child) {
        LOG.debug("{} : Child shard attached at {}", (Object)this.shardRoot, (Object)prefix);
        Preconditions.checkArgument((child != this ? 1 : 0) != 0, (String)"Attempted to attach child %s onto self", (Object)this);
        this.addChildShard(prefix, child);
        this.updateProducers();
    }

    public synchronized void onChildDetached(DOMDataTreeIdentifier prefix, DOMDataTreeShard child) {
        LOG.debug("{} : Child shard detached at {}", (Object)this.shardRoot, (Object)prefix);
        this.childShards.remove(prefix);
        this.updateProducers();
    }

    private void addChildShard(DOMDataTreeIdentifier prefix, DOMDataTreeShard child) {
        Preconditions.checkArgument((boolean)(child instanceof WriteableDOMDataTreeShard));
        this.childShards.put(prefix, new ChildShardContext(prefix, (WriteableDOMDataTreeShard)child));
    }

    DistributedShardModificationFactory createModificationFactory(Collection<DOMDataTreeIdentifier> prefixes) {
        HashMap<DOMDataTreeIdentifier, SubshardProducerSpecification> affectedSubshards = new HashMap<DOMDataTreeIdentifier, SubshardProducerSpecification>();
        for (DOMDataTreeIdentifier producerPrefix : prefixes) {
            for (ChildShardContext maybeAffected : this.childShards.values()) {
                DOMDataTreeIdentifier bindPath;
                if (producerPrefix.contains(maybeAffected.getPrefix())) {
                    bindPath = maybeAffected.getPrefix();
                } else {
                    if (!maybeAffected.getPrefix().contains(producerPrefix)) continue;
                    bindPath = producerPrefix;
                }
                SubshardProducerSpecification spec = affectedSubshards.computeIfAbsent(maybeAffected.getPrefix(), k -> new SubshardProducerSpecification(maybeAffected));
                spec.addPrefix(bindPath);
            }
        }
        DistributedShardModificationFactoryBuilder builder = new DistributedShardModificationFactoryBuilder(this.shardRoot);
        for (SubshardProducerSpecification spec : affectedSubshards.values()) {
            ForeignShardModificationContext foreignContext = new ForeignShardModificationContext(spec.getPrefix(), spec.createProducer());
            builder.addSubshard(foreignContext);
            builder.addSubshard(spec.getPrefix(), foreignContext);
        }
        return builder.build();
    }

    private void updateProducers() {
        for (ShardProxyProducer producer : this.producers) {
            producer.setModificationFactory(this.createModificationFactory(producer.getPrefixes()));
        }
    }

    public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerTreeChangeListener(YangInstanceIdentifier treeId, L listener) {
        return this.publisher.registerTreeChangeListener(treeId, listener);
    }
}

