/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import akka.actor.Address;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.opendaylight.controller.cluster.access.concepts.MemberName;

public class ShardingServiceAddressResolver {
    private final ConcurrentMap<MemberName, Address> memberNameToAddress = new ConcurrentHashMap<MemberName, Address>();
    private final String shardingServiceActorIdentifier;
    private final MemberName localMemberName;

    public ShardingServiceAddressResolver(String shardingServiceActorIdentifier, MemberName localMemberName) {
        this.shardingServiceActorIdentifier = shardingServiceActorIdentifier;
        this.localMemberName = localMemberName;
    }

    void addPeerAddress(MemberName memberName, Address address) {
        this.memberNameToAddress.put(memberName, address);
    }

    void removePeerAddress(MemberName memberName) {
        this.memberNameToAddress.remove(memberName);
    }

    Address getPeerAddress(MemberName memberName) {
        return (Address)this.memberNameToAddress.get(memberName);
    }

    StringBuilder getActorPathBuilder(Address address) {
        return new StringBuilder().append(address.toString()).append("/user/").append(this.shardingServiceActorIdentifier);
    }

    Collection<String> getShardingServicePeerActorAddresses() {
        Collection peerAddresses = this.memberNameToAddress.entrySet().stream().filter(entry -> !this.localMemberName.equals(entry.getKey())).map(entry -> this.getActorPathBuilder((Address)entry.getValue()).toString()).collect(Collectors.toList());
        return peerAddresses;
    }

    public String resolve(MemberName memberName) {
        Address address = (Address)this.memberNameToAddress.get(Objects.requireNonNull(memberName));
        Preconditions.checkNotNull((Object)address, (String)"Requested member[%s] is not present in the resolver", (Object)memberName);
        return this.getActorPathBuilder(address).toString();
    }
}

