/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class Percentage
implements TypeObject,
Serializable {
    private static final long serialVersionUID = 482899018947419815L;
    private final Uint8 _value;

    private static void check_valueRange(short value) {
        if (value <= 100) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..100]]", (int)value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public Percentage(Uint8 _value) {
        if (_value != null) {
            Percentage.check_valueRange(_value.shortValue());
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    @Deprecated(forRemoval=true)
    public Percentage(Short _value) {
        this(CodeHelpers.compatUint((Short)_value));
    }

    public Percentage(Percentage source) {
        this._value = source._value;
    }

    public static Percentage getDefaultInstance(String defaultValue) {
        return new Percentage(Uint8.valueOf((String)defaultValue));
    }

    public Uint8 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Percentage)) {
            return false;
        }
        Percentage other = (Percentage)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Percentage.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        return helper.toString();
    }
}

