/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.cluster.databroker.AbstractDOMTransactionFactory;
import org.opendaylight.controller.cluster.databroker.DOMBrokerTransactionChain;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeListener;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBrokerExtension;
import org.opendaylight.controller.md.sal.dom.api.DOMDataChangeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeCommitCohortRegistry;
import org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain;
import org.opendaylight.controller.sal.core.spi.data.DOMStore;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransactionChain;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTreeChangePublisher;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistration;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDOMBroker
extends AbstractDOMTransactionFactory<DOMStore>
implements DOMDataBroker {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDOMBroker.class);
    private final AtomicLong txNum = new AtomicLong();
    private final AtomicLong chainNum = new AtomicLong();
    private final Map<Class<? extends DOMDataBrokerExtension>, DOMDataBrokerExtension> extensions;
    private volatile AutoCloseable closeable;

    protected AbstractDOMBroker(Map<LogicalDatastoreType, DOMStore> datastores) {
        super(datastores);
        ImmutableMap.Builder extBuilder = ImmutableMap.builder();
        if (AbstractDOMBroker.isSupported(datastores, DOMStoreTreeChangePublisher.class)) {
            extBuilder.put(DOMDataTreeChangeService.class, (Object)new DOMDataTreeChangeService(){

                public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerDataTreeChangeListener(org.opendaylight.controller.md.sal.dom.api.DOMDataTreeIdentifier treeId, L listener) {
                    DOMStore store = (DOMStore)AbstractDOMBroker.this.getTxFactories().get(treeId.getDatastoreType());
                    Preconditions.checkState((store != null ? 1 : 0) != 0, (Object)"Requested logical data store is not available.");
                    return ((DOMStoreTreeChangePublisher)store).registerTreeChangeListener(treeId.getRootIdentifier(), listener);
                }
            });
        }
        if (AbstractDOMBroker.isSupported(datastores, org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistry.class)) {
            extBuilder.put(DOMDataTreeCommitCohortRegistry.class, (Object)new DOMDataTreeCommitCohortRegistry(){

                public <T extends DOMDataTreeCommitCohort> DOMDataTreeCommitCohortRegistration<T> registerCommitCohort(DOMDataTreeIdentifier path, T cohort) {
                    DOMStore store = (DOMStore)AbstractDOMBroker.this.getTxFactories().get(AbstractDOMBroker.toLegacy(path.getDatastoreType()));
                    Preconditions.checkState((store != null ? 1 : 0) != 0, (Object)"Requested logical data store is not available.");
                    return ((org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistry)store).registerCommitCohort(path, cohort);
                }
            });
        }
        this.extensions = extBuilder.build();
    }

    private static LogicalDatastoreType toLegacy(org.opendaylight.mdsal.common.api.LogicalDatastoreType datastoreType) {
        switch (datastoreType) {
            case CONFIGURATION: {
                return LogicalDatastoreType.CONFIGURATION;
            }
            case OPERATIONAL: {
                return LogicalDatastoreType.OPERATIONAL;
            }
        }
        throw new IllegalArgumentException("Unsupported data store type: " + datastoreType);
    }

    private static boolean isSupported(Map<LogicalDatastoreType, DOMStore> datastores, Class<?> expDOMStoreInterface) {
        for (DOMStore ds : datastores.values()) {
            if (expDOMStoreInterface.isAssignableFrom(ds.getClass())) continue;
            return false;
        }
        return true;
    }

    public void setCloseable(AutoCloseable closeable) {
        this.closeable = closeable;
    }

    @Override
    public void close() {
        super.close();
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (Exception e) {
                LOG.debug("Error closing instance", (Throwable)e);
            }
        }
    }

    @Override
    protected Object newTransactionIdentifier() {
        return "DOM-" + this.txNum.getAndIncrement();
    }

    public ListenerRegistration<DOMDataChangeListener> registerDataChangeListener(LogicalDatastoreType store, YangInstanceIdentifier path, DOMDataChangeListener listener, AsyncDataBroker.DataChangeScope triggeringScope) {
        DOMStore potentialStore = (DOMStore)this.getTxFactories().get(store);
        Preconditions.checkState((potentialStore != null ? 1 : 0) != 0, (Object)"Requested logical data store is not available.");
        return potentialStore.registerChangeListener(path, (AsyncDataChangeListener)listener, triggeringScope);
    }

    public Map<Class<? extends DOMDataBrokerExtension>, DOMDataBrokerExtension> getSupportedExtensions() {
        return this.extensions;
    }

    public DOMTransactionChain createTransactionChain(TransactionChainListener listener) {
        this.checkNotClosed();
        EnumMap<LogicalDatastoreType, DOMStoreTransactionChain> backingChains = new EnumMap<LogicalDatastoreType, DOMStoreTransactionChain>(LogicalDatastoreType.class);
        for (Map.Entry entry : this.getTxFactories().entrySet()) {
            backingChains.put(entry.getKey(), ((DOMStore)entry.getValue()).createTransactionChain());
        }
        long chainId = this.chainNum.getAndIncrement();
        LOG.debug("Transaction chain {} created with listener {}, backing store chains {}", new Object[]{chainId, listener, backingChains});
        return new DOMBrokerTransactionChain(chainId, backingChains, this, listener);
    }
}

