/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import akka.actor.ActorSystem;
import com.google.common.annotations.VisibleForTesting;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.databroker.ClientBackedReadTransaction;
import org.opendaylight.controller.cluster.databroker.ClientBackedReadWriteTransaction;
import org.opendaylight.controller.cluster.databroker.ClientBackedTransactionChain;
import org.opendaylight.controller.cluster.databroker.ClientBackedWriteTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransactionChain;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction;

public class ClientBackedDataStore
extends AbstractDataStore {
    public ClientBackedDataStore(ActorSystem actorSystem, ClusterWrapper cluster, Configuration configuration, DatastoreContextFactory datastoreContextFactory, DatastoreSnapshot restoreFromSnapshot) {
        super(actorSystem, cluster, configuration, datastoreContextFactory, restoreFromSnapshot);
    }

    @VisibleForTesting
    ClientBackedDataStore(ActorContext actorContext, ClientIdentifier identifier, DataStoreClient clientActor) {
        super(actorContext, identifier, clientActor);
    }

    public DOMStoreTransactionChain createTransactionChain() {
        return new ClientBackedTransactionChain(this.getClient().createLocalHistory(), this.debugAllocation());
    }

    public DOMStoreReadTransaction newReadOnlyTransaction() {
        return new ClientBackedReadTransaction(this.getClient().createSnapshot(), null, this.allocationContext());
    }

    public DOMStoreWriteTransaction newWriteOnlyTransaction() {
        return new ClientBackedWriteTransaction(this.getClient().createTransaction(), this.allocationContext());
    }

    public DOMStoreReadWriteTransaction newReadWriteTransaction() {
        return new ClientBackedReadWriteTransaction(this.getClient().createTransaction(), this.allocationContext());
    }

    private boolean debugAllocation() {
        return this.getActorContext().getDatastoreContext().isTransactionDebugContextEnabled();
    }

    private Throwable allocationContext() {
        return this.debugAllocation() ? new Throwable("allocated at") : null;
    }
}

