/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandle;
import org.opendaylight.controller.sal.core.spi.data.AbstractDOMStoreTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ClientBackedTransaction<T extends AbstractClientHandle<?>>
extends AbstractDOMStoreTransaction<TransactionIdentifier> {
    private final T delegate;

    ClientBackedTransaction(T delegate, Throwable allocationContext) {
        super((Object)((AbstractClientHandle)delegate).getIdentifier());
        this.delegate = Finalizer.recordTransaction(this, delegate, allocationContext);
    }

    final T delegate() {
        return this.delegate;
    }

    public void close() {
        ((AbstractClientHandle)this.delegate).abort();
    }

    private static final class Finalizer
    extends FinalizablePhantomReference<ClientBackedTransaction<?>> {
        private static final FinalizableReferenceQueue QUEUE = new FinalizableReferenceQueue();
        private static final Set<Finalizer> FINALIZERS = ConcurrentHashMap.newKeySet();
        private static final Logger LOG = LoggerFactory.getLogger(Finalizer.class);
        private final AbstractClientHandle<?> transaction;
        private final Throwable allocationContext;

        private Finalizer(ClientBackedTransaction<?> referent, AbstractClientHandle<?> transaction, Throwable allocationContext) {
            super(referent, QUEUE);
            this.transaction = (AbstractClientHandle)Preconditions.checkNotNull(transaction);
            this.allocationContext = allocationContext;
        }

        @Nonnull
        static <T extends AbstractClientHandle<?>> T recordTransaction(@Nonnull ClientBackedTransaction<T> referent, @Nonnull T transaction, @Nullable Throwable allocationContext) {
            FINALIZERS.add(new Finalizer(referent, transaction, allocationContext));
            return transaction;
        }

        public void finalizeReferent() {
            FINALIZERS.remove((Object)this);
            if (this.transaction.abort()) {
                LOG.info("Aborted orphan transaction {}", this.transaction, (Object)this.allocationContext);
            }
        }
    }
}

