/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.cluster.databroker.ClientBackedReadTransaction;
import org.opendaylight.controller.cluster.databroker.ClientBackedReadWriteTransaction;
import org.opendaylight.controller.cluster.databroker.ClientBackedWriteTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandle;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransactionChain;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction;
import org.opendaylight.mdsal.common.api.TransactionChainClosedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientBackedTransactionChain
implements DOMStoreTransactionChain {
    private static final Logger LOG = LoggerFactory.getLogger(ClientBackedTransactionChain.class);
    @GuardedBy(value="this")
    private final Map<AbstractClientHandle<?>, Boolean> openSnapshots = new WeakHashMap();
    private final ClientLocalHistory history;
    private final boolean debugAllocation;

    ClientBackedTransactionChain(ClientLocalHistory history, boolean debugAllocation) {
        this.history = (ClientLocalHistory)Preconditions.checkNotNull((Object)history);
        this.debugAllocation = debugAllocation;
    }

    public DOMStoreReadTransaction newReadOnlyTransaction() {
        return new ClientBackedReadTransaction(this.createSnapshot(), this, this.allocationContext());
    }

    public DOMStoreReadWriteTransaction newReadWriteTransaction() {
        return new ClientBackedReadWriteTransaction(this.createTransaction(), this.allocationContext());
    }

    public DOMStoreWriteTransaction newWriteOnlyTransaction() {
        return new ClientBackedWriteTransaction(this.createTransaction(), this.allocationContext());
    }

    public synchronized void close() {
        for (AbstractClientHandle<?> snap : this.openSnapshots.keySet()) {
            LOG.warn("Aborting unclosed transaction {}", (Object)snap.getIdentifier());
            snap.abort();
        }
        this.openSnapshots.clear();
        this.history.close();
    }

    synchronized void snapshotClosed(ClientSnapshot clientTransaction) {
        this.openSnapshots.remove(clientTransaction);
    }

    private ClientSnapshot createSnapshot() {
        try {
            return this.recordSnapshot(this.history.takeSnapshot());
        }
        catch (TransactionChainClosedException e) {
            throw new org.opendaylight.controller.md.sal.common.api.data.TransactionChainClosedException("Transaction chain has been closed", (Throwable)e);
        }
    }

    private ClientTransaction createTransaction() {
        try {
            return this.recordSnapshot(this.history.createTransaction());
        }
        catch (TransactionChainClosedException e) {
            throw new org.opendaylight.controller.md.sal.common.api.data.TransactionChainClosedException("Transaction chain has been closed", (Throwable)e);
        }
    }

    private Throwable allocationContext() {
        return this.debugAllocation ? new Throwable("allocated at") : null;
    }

    private synchronized <T extends AbstractClientHandle<?>> T recordSnapshot(T snapshot) {
        this.openSnapshots.put(snapshot, Boolean.TRUE);
        return snapshot;
    }
}

