/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.cluster.access.commands.AbortLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.AbstractLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.CommitLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequestBuilder;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.commands.TransactionAbortRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionDelete;
import org.opendaylight.controller.cluster.access.commands.TransactionDoCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionMerge;
import org.opendaylight.controller.cluster.access.commands.TransactionModification;
import org.opendaylight.controller.cluster.access.commands.TransactionPreCommitRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.commands.TransactionWrite;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.datastore.util.AbstractDataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.CursorAwareDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class LocalReadWriteProxyTransaction
extends LocalProxyTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(LocalReadWriteProxyTransaction.class);
    private final CursorAwareDataTreeModification modification;
    private Supplier<? extends RuntimeException> closedException;
    private CursorAwareDataTreeModification sealedModification;
    private Exception recordedFailure;

    LocalReadWriteProxyTransaction(ProxyHistory parent, TransactionIdentifier identifier, DataTreeSnapshot snapshot) {
        super(parent, identifier, false);
        this.modification = (CursorAwareDataTreeModification)snapshot.newModification();
    }

    LocalReadWriteProxyTransaction(ProxyHistory parent, TransactionIdentifier identifier) {
        super(parent, identifier, true);
        this.modification = null;
    }

    @Override
    boolean isSnapshotOnly() {
        return false;
    }

    CursorAwareDataTreeSnapshot readOnlyView() {
        return this.getModification();
    }

    @Override
    void doDelete(YangInstanceIdentifier path) {
        CursorAwareDataTreeModification mod = this.getModification();
        if (this.recordedFailure != null) {
            LOG.debug("Transaction {} recorded failure, ignoring delete of {}", (Object)this.getIdentifier(), (Object)path);
            return;
        }
        try {
            mod.delete(path);
        }
        catch (Exception e) {
            LOG.debug("Transaction {} delete on {} incurred failure, delaying it until commit", new Object[]{this.getIdentifier(), path, e});
            this.recordedFailure = e;
        }
    }

    @Override
    void doMerge(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        CursorAwareDataTreeModification mod = this.getModification();
        if (this.recordedFailure != null) {
            LOG.debug("Transaction {} recorded failure, ignoring merge to {}", (Object)this.getIdentifier(), (Object)path);
            return;
        }
        try {
            mod.merge(path, data);
        }
        catch (Exception e) {
            LOG.debug("Transaction {} merge to {} incurred failure, delaying it until commit", new Object[]{this.getIdentifier(), path, e});
            this.recordedFailure = e;
        }
    }

    @Override
    void doWrite(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        CursorAwareDataTreeModification mod = this.getModification();
        if (this.recordedFailure != null) {
            LOG.debug("Transaction {} recorded failure, ignoring write to {}", (Object)this.getIdentifier(), (Object)path);
            return;
        }
        try {
            mod.write(path, data);
        }
        catch (Exception e) {
            LOG.debug("Transaction {} write to {} incurred failure, delaying it until commit", new Object[]{this.getIdentifier(), path, e});
            this.recordedFailure = e;
        }
    }

    private RuntimeException abortedException() {
        return new IllegalStateException("Tracker " + this.getIdentifier() + " has been aborted");
    }

    private RuntimeException submittedException() {
        return new IllegalStateException("Tracker " + this.getIdentifier() + " has been submitted");
    }

    CommitLocalTransactionRequest commitRequest(boolean coordinated) {
        CursorAwareDataTreeModification mod = this.getModification();
        CommitLocalTransactionRequest ret = new CommitLocalTransactionRequest(this.getIdentifier(), this.nextSequence(), this.localActor(), (DataTreeModification)mod, this.recordedFailure, coordinated);
        this.closedException = this::submittedException;
        return ret;
    }

    private void sealModification() {
        Preconditions.checkState((this.sealedModification == null ? 1 : 0) != 0, (String)"Transaction %s is already sealed", (Object)this);
        CursorAwareDataTreeModification mod = this.getModification();
        mod.ready();
        this.sealedModification = mod;
    }

    @Override
    void sealOnly() {
        this.sealModification();
        super.sealOnly();
    }

    @Override
    boolean sealAndSend(com.google.common.base.Optional<Long> enqueuedTicks) {
        this.sealModification();
        return super.sealAndSend(enqueuedTicks);
    }

    @Override
    Optional<ModifyTransactionRequest> flushState() {
        final ModifyTransactionRequestBuilder b = new ModifyTransactionRequestBuilder(this.getIdentifier(), this.localActor());
        b.setSequence(0L);
        this.sealedModification.applyToCursor((DataTreeModificationCursor)new AbstractDataTreeModificationCursor(){

            public void write(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
                b.addModification((TransactionModification)new TransactionWrite(this.current().node(child), data));
            }

            public void merge(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
                b.addModification((TransactionModification)new TransactionMerge(this.current().node(child), data));
            }

            public void delete(YangInstanceIdentifier.PathArgument child) {
                b.addModification((TransactionModification)new TransactionDelete(this.current().node(child)));
            }
        });
        return Optional.of(b.build());
    }

    DataTreeSnapshot getSnapshot() {
        Preconditions.checkState((this.sealedModification != null ? 1 : 0) != 0, (String)"Proxy %s is not sealed yet", (Object)this.getIdentifier());
        return this.sealedModification;
    }

    @Override
    void applyForwardedModifyTransactionRequest(ModifyTransactionRequest request, @Nullable Consumer<Response<?, ?>> callback) {
        this.commonModifyTransactionRequest(request, callback, this::sendRequest);
    }

    @Override
    void replayModifyTransactionRequest(ModifyTransactionRequest request, @Nullable Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        this.commonModifyTransactionRequest(request, callback, (req, cb) -> this.enqueueRequest((TransactionRequest<?>)req, (Consumer<Response<?, ?>>)cb, enqueuedTicks));
    }

    private void commonModifyTransactionRequest(ModifyTransactionRequest request, @Nullable Consumer<Response<?, ?>> callback, BiConsumer<TransactionRequest<?>, Consumer<Response<?, ?>>> sendMethod) {
        for (TransactionModification mod : request.getModifications()) {
            if (mod instanceof TransactionWrite) {
                this.write(mod.getPath(), ((TransactionWrite)mod).getData());
                continue;
            }
            if (mod instanceof TransactionMerge) {
                this.merge(mod.getPath(), ((TransactionMerge)mod).getData());
                continue;
            }
            if (mod instanceof TransactionDelete) {
                this.delete(mod.getPath());
                continue;
            }
            throw new IllegalArgumentException("Unsupported modification " + mod);
        }
        Optional maybeProtocol = request.getPersistenceProtocol();
        if (maybeProtocol.isPresent()) {
            Verify.verify((callback != null ? 1 : 0) != 0, (String)"Request %s has null callback", (Object[])new Object[]{request});
            if (this.markSealed()) {
                this.sealOnly();
            }
            switch ((PersistenceProtocol)maybeProtocol.get()) {
                case ABORT: {
                    sendMethod.accept((TransactionRequest<?>)new AbortLocalTransactionRequest(this.getIdentifier(), this.localActor()), callback);
                    break;
                }
                case READY: {
                    break;
                }
                case SIMPLE: {
                    sendMethod.accept((TransactionRequest<?>)this.commitRequest(false), callback);
                    break;
                }
                case THREE_PHASE: {
                    sendMethod.accept((TransactionRequest<?>)this.commitRequest(true), callback);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled protocol " + maybeProtocol.get());
                }
            }
        }
    }

    @Override
    void handleReplayedLocalRequest(AbstractLocalTransactionRequest<?> request, Consumer<Response<?, ?>> callback, long now) {
        if (request instanceof CommitLocalTransactionRequest) {
            this.enqueueRequest((TransactionRequest<?>)this.rebaseCommit((CommitLocalTransactionRequest)request), callback, now);
        } else {
            super.handleReplayedLocalRequest(request, callback, now);
        }
    }

    @Override
    void handleReplayedRemoteRequest(TransactionRequest<?> request, @Nullable Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        LOG.debug("Applying replayed request {}", request);
        if (request instanceof TransactionPreCommitRequest) {
            this.enqueueRequest((TransactionRequest<?>)new TransactionPreCommitRequest(this.getIdentifier(), this.nextSequence(), this.localActor()), callback, enqueuedTicks);
        } else if (request instanceof TransactionDoCommitRequest) {
            this.enqueueRequest((TransactionRequest<?>)new TransactionDoCommitRequest(this.getIdentifier(), this.nextSequence(), this.localActor()), callback, enqueuedTicks);
        } else if (request instanceof TransactionAbortRequest) {
            this.enqueueDoAbort(callback, enqueuedTicks);
        } else {
            super.handleReplayedRemoteRequest(request, callback, enqueuedTicks);
        }
    }

    @Override
    void handleForwardedRemoteRequest(TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        LOG.debug("Applying forwarded request {}", request);
        if (request instanceof TransactionPreCommitRequest) {
            this.sendRequest((TransactionRequest<?>)new TransactionPreCommitRequest(this.getIdentifier(), this.nextSequence(), this.localActor()), callback);
        } else if (request instanceof TransactionDoCommitRequest) {
            this.sendRequest((TransactionRequest<?>)new TransactionDoCommitRequest(this.getIdentifier(), this.nextSequence(), this.localActor()), callback);
        } else if (request instanceof TransactionAbortRequest) {
            this.sendDoAbort(callback);
        } else {
            super.handleForwardedRemoteRequest(request, callback);
        }
    }

    @Override
    void forwardToLocal(LocalProxyTransaction successor, TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        if (request instanceof CommitLocalTransactionRequest) {
            Verify.verify((boolean)(successor instanceof LocalReadWriteProxyTransaction));
            ((LocalReadWriteProxyTransaction)successor).sendRebased((CommitLocalTransactionRequest)request, callback);
            LOG.debug("Forwarded request {} to successor {}", request, (Object)successor);
        } else {
            super.forwardToLocal(successor, request, callback);
        }
    }

    @Override
    void sendAbort(TransactionRequest<?> request, Consumer<Response<?, ?>> callback) {
        super.sendAbort(request, callback);
        this.closedException = this::abortedException;
    }

    @Override
    void enqueueAbort(TransactionRequest<?> request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        super.enqueueAbort(request, callback, enqueuedTicks);
        this.closedException = this::abortedException;
    }

    @Nonnull
    private CursorAwareDataTreeModification getModification() {
        if (this.closedException != null) {
            throw this.closedException.get();
        }
        return (CursorAwareDataTreeModification)Preconditions.checkNotNull((Object)this.modification, (String)"Transaction %s is DONE", (Object)this.getIdentifier());
    }

    private void sendRebased(CommitLocalTransactionRequest request, Consumer<Response<?, ?>> callback) {
        this.sendRequest((TransactionRequest<?>)this.rebaseCommit(request), callback);
    }

    private CommitLocalTransactionRequest rebaseCommit(CommitLocalTransactionRequest request) {
        CursorAwareDataTreeModification mod = this.getModification();
        try (DataTreeModificationCursor cursor = mod.createCursor(YangInstanceIdentifier.EMPTY);){
            request.getModification().applyToCursor(cursor);
        }
        if (this.markSealed()) {
            this.sealOnly();
        }
        return this.commitRequest(request.isCoordinated());
    }
}

