/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractShardBackendResolver;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
final class ModuleShardBackendResolver
extends AbstractShardBackendResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleShardBackendResolver.class);
    private final ConcurrentMap<Long, AbstractShardBackendResolver.ShardState> backends = new ConcurrentHashMap<Long, AbstractShardBackendResolver.ShardState>();
    private final ActorContext actorContext;
    @GuardedBy(value="this")
    private long nextShard = 1L;
    private volatile BiMap<String, Long> shards = ImmutableBiMap.of((Object)"default", (Object)0L);

    ModuleShardBackendResolver(ClientIdentifier clientId, ActorContext actorContext) {
        super(clientId, actorContext);
        this.actorContext = (ActorContext)Preconditions.checkNotNull((Object)actorContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long resolveShardForPath(YangInstanceIdentifier path) {
        String shardName = this.actorContext.getShardStrategyFactory().getStrategy(path).findShard(path);
        Long cookie = (Long)this.shards.get((Object)shardName);
        if (cookie == null) {
            ModuleShardBackendResolver moduleShardBackendResolver = this;
            synchronized (moduleShardBackendResolver) {
                cookie = (Long)this.shards.get((Object)shardName);
                if (cookie == null) {
                    cookie = this.nextShard++;
                    ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
                    builder.putAll(this.shards);
                    builder.put((Object)shardName, (Object)cookie);
                    this.shards = builder.build();
                }
            }
        }
        return cookie;
    }

    public CompletionStage<ShardBackendInfo> getBackendInfo(Long cookie) {
        AbstractShardBackendResolver.ShardState existing = (AbstractShardBackendResolver.ShardState)this.backends.get(cookie);
        if (existing != null) {
            return existing.getStage();
        }
        String shardName = (String)this.shards.inverse().get((Object)cookie);
        if (shardName == null) {
            LOG.warn("Failing request for non-existent cookie {}", (Object)cookie);
            throw new IllegalArgumentException("Cookie " + cookie + " does not have a shard assigned");
        }
        LOG.debug("Resolving cookie {} to shard {}", (Object)cookie, (Object)shardName);
        AbstractShardBackendResolver.ShardState toInsert = this.resolveBackendInfo(shardName, cookie);
        AbstractShardBackendResolver.ShardState raced = this.backends.putIfAbsent(cookie, toInsert);
        if (raced != null) {
            LOG.debug("Race during insertion of state for cookie {} shard {}", (Object)cookie, (Object)shardName);
            return raced.getStage();
        }
        CompletionStage<ShardBackendInfo> stage = toInsert.getStage();
        stage.whenComplete((info, failure) -> {
            if (failure != null) {
                LOG.debug("Resolution of cookie {} shard {} failed, removing state", new Object[]{cookie, shardName, failure});
                this.backends.remove(cookie, toInsert);
                this.flushCache(shardName);
            }
        });
        return stage;
    }

    public CompletionStage<ShardBackendInfo> refreshBackendInfo(Long cookie, ShardBackendInfo staleInfo) {
        AbstractShardBackendResolver.ShardState existing = (AbstractShardBackendResolver.ShardState)this.backends.get(cookie);
        if (existing != null) {
            if (!staleInfo.equals((Object)existing.getResult())) {
                return existing.getStage();
            }
            LOG.debug("Invalidating backend information {}", (Object)staleInfo);
            this.flushCache(staleInfo.getShardName());
            LOG.trace("Invalidated cache %s", (Object)staleInfo);
            this.backends.remove(cookie, existing);
        }
        return this.getBackendInfo(cookie);
    }
}

