/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.Props;
import akka.japi.Creator;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientActor;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.SimpleDataStoreClientBehavior;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;

public final class SimpleDataStoreClientActor
extends AbstractDataStoreClientActor {
    private final String shardName;

    private SimpleDataStoreClientActor(FrontendIdentifier frontendId, ActorContext actorContext, String shardName) {
        super(frontendId, actorContext);
        this.shardName = (String)Preconditions.checkNotNull((Object)shardName);
    }

    @Override
    AbstractDataStoreClientBehavior initialBehavior(ClientActorContext context, ActorContext actorContext) {
        return new SimpleDataStoreClientBehavior(context, actorContext, this.shardName);
    }

    public static Props props(@Nonnull MemberName memberName, @Nonnull String storeName, ActorContext ctx, String shardName) {
        String name = "datastore-" + storeName;
        FrontendIdentifier frontendId = FrontendIdentifier.create((MemberName)memberName, (FrontendType)FrontendType.forName((String)name));
        return Props.create(SimpleDataStoreClientActor.class, (Creator & Serializable)() -> new SimpleDataStoreClientActor(frontendId, ctx, shardName));
    }
}

