/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.cluster.datastore.DelayedListenerRegistration;
import org.opendaylight.controller.cluster.datastore.LeaderLocalDelegateFactory;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.actors.DataTreeNotificationListenerRegistrationActor;
import org.opendaylight.controller.cluster.datastore.messages.EnableNotification;
import org.opendaylight.controller.cluster.datastore.messages.ListenerRegistrationMessage;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeNotificationListenerReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDataListenerSupport<L extends EventListener, M extends ListenerRegistrationMessage>
extends LeaderLocalDelegateFactory<M> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Collection<DelayedListenerRegistration<L, M>> delayedListenerRegistrations = ConcurrentHashMap.newKeySet();
    private final Collection<DelayedListenerRegistration<L, M>> delayedListenerOnAllRegistrations = ConcurrentHashMap.newKeySet();
    private final Collection<ActorSelection> leaderOnlyListenerActors = ConcurrentHashMap.newKeySet();
    private final Collection<ActorSelection> allListenerActors = ConcurrentHashMap.newKeySet();

    protected AbstractDataListenerSupport(Shard shard) {
        super(shard);
    }

    Collection<ActorSelection> getListenerActors() {
        return new ArrayList<ActorSelection>(this.allListenerActors);
    }

    @Override
    void onLeadershipChange(boolean isLeader, boolean hasLeader) {
        this.log.debug("{}: onLeadershipChange, isLeader: {}, hasLeader : {}", new Object[]{this.persistenceId(), isLeader, hasLeader});
        EnableNotification msg = new EnableNotification(isLeader, this.persistenceId());
        for (ActorSelection actorSelection : this.leaderOnlyListenerActors) {
            actorSelection.tell((Object)msg, this.getSelf());
        }
        if (hasLeader) {
            for (DelayedListenerRegistration delayedListenerRegistration : this.delayedListenerOnAllRegistrations) {
                delayedListenerRegistration.doRegistration(this);
            }
            this.delayedListenerOnAllRegistrations.clear();
        }
        if (isLeader) {
            for (DelayedListenerRegistration delayedListenerRegistration : this.delayedListenerRegistrations) {
                delayedListenerRegistration.doRegistration(this);
            }
            this.delayedListenerRegistrations.clear();
        }
    }

    @Override
    void onMessage(M message, boolean isLeader, boolean hasLeader) {
        this.log.debug("{}: {} for {}, isLeader: {}, hasLeader: {}", new Object[]{this.persistenceId(), this.logName(), message, isLeader, hasLeader});
        ActorRef registrationActor = this.createActor(DataTreeNotificationListenerRegistrationActor.props());
        if (hasLeader && message.isRegisterOnAllInstances() || isLeader) {
            this.doRegistration(message, registrationActor);
        } else {
            this.log.debug("{}: Shard is not the leader - delaying registration", (Object)this.persistenceId());
            DelayedListenerRegistration delayedReg = new DelayedListenerRegistration(message, registrationActor);
            Collection delayedRegList = message.isRegisterOnAllInstances() ? this.delayedListenerOnAllRegistrations : this.delayedListenerRegistrations;
            delayedRegList.add(delayedReg);
            registrationActor.tell((Object)new DataTreeNotificationListenerRegistrationActor.SetRegistration(delayedReg, () -> delayedRegList.remove(delayedReg)), ActorRef.noSender());
        }
        this.log.debug("{}: {} sending reply, listenerRegistrationPath = {} ", new Object[]{this.persistenceId(), this.logName(), registrationActor.path()});
        this.tellSender(new RegisterDataTreeNotificationListenerReply(registrationActor));
    }

    protected ActorSelection processListenerRegistrationMessage(M message) {
        ActorSelection listenerActor = this.selectActor(message.getListenerActorPath());
        listenerActor.tell((Object)new EnableNotification(true, this.persistenceId()), this.getSelf());
        if (!message.isRegisterOnAllInstances()) {
            this.leaderOnlyListenerActors.add(listenerActor);
        }
        this.allListenerActors.add(listenerActor);
        return listenerActor;
    }

    protected Logger log() {
        return this.log;
    }

    protected void removeListenerActor(ActorSelection listenerActor) {
        this.allListenerActors.remove(listenerActor);
        this.leaderOnlyListenerActors.remove(listenerActor);
    }

    abstract void doRegistration(M var1, ActorRef var2);

    protected abstract String logName();
}

