/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;

public class ClusterWrapperImpl
implements ClusterWrapper {
    private final Cluster cluster;
    private final MemberName currentMemberName;
    private final Address selfAddress;

    public ClusterWrapperImpl(ActorSystem actorSystem) {
        Preconditions.checkNotNull((Object)actorSystem, (Object)"actorSystem should not be null");
        this.cluster = Cluster.get((ActorSystem)actorSystem);
        Preconditions.checkState((this.cluster.getSelfRoles().size() > 0 ? 1 : 0) != 0, (Object)"No akka roles were specified.\nOne way to specify the member name is to pass a property on the command line like so\n   -Dakka.cluster.roles.0=member-3\nmember-3 here would be the name of the member");
        this.currentMemberName = MemberName.forName((String)((String)this.cluster.getSelfRoles().iterator().next()));
        this.selfAddress = this.cluster.selfAddress();
    }

    @Override
    public void subscribeToMemberEvents(ActorRef actorRef) {
        Preconditions.checkNotNull((Object)actorRef, (Object)"actorRef should not be null");
        this.cluster.subscribe(actorRef, (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent.initialStateAsEvents(), new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.UnreachableMember.class, ClusterEvent.ReachableMember.class});
    }

    @Override
    public MemberName getCurrentMemberName() {
        return this.currentMemberName;
    }

    @Override
    public Address getSelfAddress() {
        return this.selfAddress;
    }
}

