/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.Status;
import akka.dispatch.ExecutionContexts;
import akka.dispatch.Futures;
import akka.dispatch.Recover;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.DataTreeCohortActor;
import org.opendaylight.controller.cluster.datastore.DataTreeCohortActorRegistry;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

class CompositeDataTreeCohort {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeDataTreeCohort.class);
    static final Recover<Object> EXCEPTION_TO_MESSAGE = new Recover<Object>(){

        public Status.Failure recover(Throwable error) {
            return new Status.Failure(error);
        }
    };
    private final DataTreeCohortActorRegistry registry;
    private final TransactionIdentifier txId;
    private final SchemaContext schema;
    private final Timeout timeout;
    private List<DataTreeCohortActor.Success> successfulFromPrevious;
    private State state = State.IDLE;

    CompositeDataTreeCohort(DataTreeCohortActorRegistry registry, TransactionIdentifier transactionID, SchemaContext schema, Timeout timeout) {
        this.registry = (DataTreeCohortActorRegistry)((Object)Preconditions.checkNotNull((Object)((Object)registry)));
        this.txId = (TransactionIdentifier)Preconditions.checkNotNull((Object)transactionID);
        this.schema = (SchemaContext)Preconditions.checkNotNull((Object)schema);
        this.timeout = (Timeout)Preconditions.checkNotNull((Object)timeout);
    }

    void reset() {
        switch (this.state) {
            case CAN_COMMIT_SENT: 
            case CAN_COMMIT_SUCCESSFUL: 
            case PRE_COMMIT_SENT: 
            case PRE_COMMIT_SUCCESSFUL: 
            case COMMIT_SENT: {
                this.abort();
                break;
            }
            case ABORTED: 
            case COMMITED: 
            case FAILED: 
            case IDLE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled state " + (Object)((Object)this.state));
            }
        }
        this.successfulFromPrevious = null;
        this.state = State.IDLE;
    }

    void canCommit(DataTreeCandidate tip) throws ExecutionException, TimeoutException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: canCommit - candidate: {}", (Object)this.txId, (Object)tip);
        } else {
            LOG.debug("{}: canCommit - candidate rootPath: {}", (Object)this.txId, (Object)tip.getRootPath());
        }
        List<DataTreeCohortActor.CanCommit> messages = this.registry.createCanCommitMessages(this.txId, tip, this.schema);
        LOG.debug("{}: canCommit - messages: {}", (Object)this.txId, messages);
        if (messages.isEmpty()) {
            this.successfulFromPrevious = ImmutableList.of();
            this.changeStateFrom(State.IDLE, State.CAN_COMMIT_SUCCESSFUL);
            return;
        }
        ArrayList<Map.Entry<ActorRef, Future<Object>>> futures = new ArrayList<Map.Entry<ActorRef, Future<Object>>>(messages.size());
        for (DataTreeCohortActor.CanCommit message : messages) {
            ActorRef actor = message.getCohort();
            Future future = Patterns.ask((ActorRef)actor, (Object)message, (Timeout)this.timeout).recover(EXCEPTION_TO_MESSAGE, (ExecutionContext)ExecutionContexts.global());
            LOG.trace("{}: requesting canCommit from {}", (Object)this.txId, (Object)actor);
            futures.add(new AbstractMap.SimpleImmutableEntry<ActorRef, Future>(actor, future));
        }
        this.changeStateFrom(State.IDLE, State.CAN_COMMIT_SENT);
        this.processResponses(futures, State.CAN_COMMIT_SENT, State.CAN_COMMIT_SUCCESSFUL);
    }

    void preCommit() throws ExecutionException, TimeoutException {
        LOG.debug("{}: preCommit - successfulFromPrevious: {}", (Object)this.txId, this.successfulFromPrevious);
        Preconditions.checkState((this.successfulFromPrevious != null ? 1 : 0) != 0);
        if (this.successfulFromPrevious.isEmpty()) {
            this.changeStateFrom(State.CAN_COMMIT_SUCCESSFUL, State.PRE_COMMIT_SUCCESSFUL);
            return;
        }
        List<Map.Entry<ActorRef, Future<Object>>> futures = this.sendMessageToSuccessful(new DataTreeCohortActor.PreCommit(this.txId));
        this.changeStateFrom(State.CAN_COMMIT_SUCCESSFUL, State.PRE_COMMIT_SENT);
        this.processResponses(futures, State.PRE_COMMIT_SENT, State.PRE_COMMIT_SUCCESSFUL);
    }

    void commit() throws ExecutionException, TimeoutException {
        LOG.debug("{}: commit - successfulFromPrevious: {}", (Object)this.txId, this.successfulFromPrevious);
        if (this.successfulFromPrevious.isEmpty()) {
            this.changeStateFrom(State.PRE_COMMIT_SUCCESSFUL, State.COMMITED);
            return;
        }
        Preconditions.checkState((this.successfulFromPrevious != null ? 1 : 0) != 0);
        List<Map.Entry<ActorRef, Future<Object>>> futures = this.sendMessageToSuccessful(new DataTreeCohortActor.Commit(this.txId));
        this.changeStateFrom(State.PRE_COMMIT_SUCCESSFUL, State.COMMIT_SENT);
        this.processResponses(futures, State.COMMIT_SENT, State.COMMITED);
    }

    Optional<List<Future<Object>>> abort() {
        LOG.debug("{}: abort - successfulFromPrevious: {}", (Object)this.txId, this.successfulFromPrevious);
        this.state = State.ABORTED;
        if (this.successfulFromPrevious == null || this.successfulFromPrevious.isEmpty()) {
            return Optional.empty();
        }
        DataTreeCohortActor.Abort message = new DataTreeCohortActor.Abort(this.txId);
        ArrayList<Future> futures = new ArrayList<Future>(this.successfulFromPrevious.size());
        for (DataTreeCohortActor.Success s : this.successfulFromPrevious) {
            futures.add(Patterns.ask((ActorRef)s.getCohort(), (Object)message, (Timeout)this.timeout));
        }
        return Optional.of(futures);
    }

    private List<Map.Entry<ActorRef, Future<Object>>> sendMessageToSuccessful(Object message) {
        LOG.debug("{}: sendMesageToSuccessful: {}", (Object)this.txId, message);
        ArrayList<Map.Entry<ActorRef, Future<Object>>> ret = new ArrayList<Map.Entry<ActorRef, Future<Object>>>(this.successfulFromPrevious.size());
        for (DataTreeCohortActor.Success s : this.successfulFromPrevious) {
            ActorRef actor = s.getCohort();
            ret.add(new AbstractMap.SimpleImmutableEntry<ActorRef, Future>(actor, Patterns.ask((ActorRef)actor, (Object)message, (Timeout)this.timeout)));
        }
        return ret;
    }

    private void processResponses(List<Map.Entry<ActorRef, Future<Object>>> futures, State currentState, State afterState) throws TimeoutException, ExecutionException {
        Iterable results;
        LOG.debug("{}: processResponses - currentState: {}, afterState: {}", new Object[]{this.txId, currentState, afterState});
        try {
            results = (Iterable)Await.result((Awaitable)Futures.sequence((Iterable)Lists.transform(futures, Map.Entry::getValue), (ExecutionContext)ExecutionContexts.global()), (Duration)this.timeout.duration());
        }
        catch (TimeoutException e) {
            this.successfulFromPrevious = null;
            LOG.debug("{}: processResponses - error from Future", (Object)this.txId, (Object)e);
            for (Map.Entry<ActorRef, Future<Object>> f : futures) {
                if (f.getValue().isCompleted()) continue;
                LOG.info("{}: actor {} failed to respond", (Object)this.txId, (Object)f.getKey());
            }
            throw e;
        }
        catch (ExecutionException e) {
            this.successfulFromPrevious = null;
            LOG.debug("{}: processResponses - error from Future", (Object)this.txId, (Object)e);
            throw e;
        }
        catch (Exception e) {
            this.successfulFromPrevious = null;
            LOG.debug("{}: processResponses - error from Future", (Object)this.txId, (Object)e);
            throw new ExecutionException(e);
        }
        ArrayList<Status.Failure> failed = new ArrayList<Status.Failure>(1);
        ArrayList<DataTreeCohortActor.Success> successful = new ArrayList<DataTreeCohortActor.Success>(futures.size());
        for (Object result : results) {
            if (result instanceof DataTreeCohortActor.Success) {
                successful.add((DataTreeCohortActor.Success)result);
                continue;
            }
            if (result instanceof Status.Failure) {
                failed.add((Status.Failure)result);
                continue;
            }
            LOG.warn("{}: unrecognized response {}, ignoring it", result);
        }
        LOG.debug("{}: processResponses - successful: {}, failed: {}", new Object[]{this.txId, successful, failed});
        this.successfulFromPrevious = successful;
        if (!failed.isEmpty()) {
            this.changeStateFrom(currentState, State.FAILED);
            Iterator it = failed.iterator();
            Throwable firstEx = ((Status.Failure)it.next()).cause();
            while (it.hasNext()) {
                firstEx.addSuppressed(((Status.Failure)it.next()).cause());
            }
            Throwables.throwIfInstanceOf((Throwable)firstEx, ExecutionException.class);
            Throwables.throwIfInstanceOf((Throwable)firstEx, TimeoutException.class);
            throw new ExecutionException(firstEx);
        }
        this.changeStateFrom(currentState, afterState);
    }

    void changeStateFrom(State expected, State followup) {
        Preconditions.checkState((this.state == expected ? 1 : 0) != 0);
        this.state = followup;
    }

    private static enum State {
        IDLE,
        CAN_COMMIT_SENT,
        CAN_COMMIT_SUCCESSFUL,
        PRE_COMMIT_SENT,
        PRE_COMMIT_SUCCESSFUL,
        COMMIT_SENT,
        COMMITED,
        FAILED,
        ABORTED;

    }
}

