/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.PoisonPill;
import akka.dispatch.OnComplete;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.datastore.DataChangeListener;
import org.opendaylight.controller.cluster.datastore.exceptions.LocalShardNotFoundException;
import org.opendaylight.controller.cluster.datastore.messages.CloseDataTreeNotificationListenerRegistration;
import org.opendaylight.controller.cluster.datastore.messages.RegisterChangeListener;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeNotificationListenerReply;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeListener;
import org.opendaylight.controller.md.sal.dom.api.ClusteredDOMDataChangeListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Future;

public class DataChangeListenerRegistrationProxy
implements ListenerRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(DataChangeListenerRegistrationProxy.class);
    private final AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>> listener;
    private final String shardName;
    private final ActorContext actorContext;
    private ActorRef dataChangeListenerActor;
    private volatile ActorSelection listenerRegistrationActor;
    private boolean closed = false;

    public <L extends AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>>> DataChangeListenerRegistrationProxy(String shardName, ActorContext actorContext, L listener) {
        this.shardName = (String)Preconditions.checkNotNull((Object)shardName);
        this.actorContext = (ActorContext)Preconditions.checkNotNull((Object)actorContext);
        this.listener = (AsyncDataChangeListener)Preconditions.checkNotNull(listener);
    }

    @VisibleForTesting
    ActorSelection getListenerRegistrationActor() {
        return this.listenerRegistrationActor;
    }

    @VisibleForTesting
    ActorRef getDataChangeListenerActor() {
        return this.dataChangeListenerActor;
    }

    public Object getInstance() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setListenerRegistrationActor(ActorSelection listenerRegistrationActor) {
        if (listenerRegistrationActor == null) {
            return;
        }
        boolean sendCloseMessage = false;
        DataChangeListenerRegistrationProxy dataChangeListenerRegistrationProxy = this;
        synchronized (dataChangeListenerRegistrationProxy) {
            if (this.closed) {
                sendCloseMessage = true;
            } else {
                this.listenerRegistrationActor = listenerRegistrationActor;
            }
        }
        if (sendCloseMessage) {
            listenerRegistrationActor.tell((Object)CloseDataTreeNotificationListenerRegistration.getInstance(), ActorRef.noSender());
        }
    }

    public void init(final YangInstanceIdentifier path, final AsyncDataBroker.DataChangeScope scope) {
        this.dataChangeListenerActor = this.actorContext.getActorSystem().actorOf(DataChangeListener.props(this.listener, path).withDispatcher(this.actorContext.getNotificationDispatcherPath()));
        Future<ActorRef> findFuture = this.actorContext.findLocalShardAsync(this.shardName);
        findFuture.onComplete((Function1)new OnComplete<ActorRef>(){

            public void onComplete(Throwable failure, ActorRef shard) {
                if (failure instanceof LocalShardNotFoundException) {
                    LOG.debug("No local shard found for {} - DataChangeListener {} at path {} cannot be registered", new Object[]{DataChangeListenerRegistrationProxy.this.shardName, DataChangeListenerRegistrationProxy.this.listener, path});
                } else if (failure != null) {
                    LOG.error("Failed to find local shard {} - DataChangeListener {} at path {} cannot be registered: {}", new Object[]{DataChangeListenerRegistrationProxy.this.shardName, DataChangeListenerRegistrationProxy.this.listener, path, failure});
                } else {
                    DataChangeListenerRegistrationProxy.this.doRegistration(shard, path, scope);
                }
            }
        }, this.actorContext.getClientDispatcher());
    }

    private void doRegistration(ActorRef shard, final YangInstanceIdentifier path, AsyncDataBroker.DataChangeScope scope) {
        Future<Object> future = this.actorContext.executeOperationAsync(shard, (Object)new RegisterChangeListener(path, this.dataChangeListenerActor, scope, this.listener instanceof ClusteredDOMDataChangeListener), this.actorContext.getDatastoreContext().getShardInitializationTimeout());
        future.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object result) {
                if (failure != null) {
                    LOG.error("Failed to register DataChangeListener {} at path {}", new Object[]{DataChangeListenerRegistrationProxy.this.listener, path.toString(), failure});
                } else {
                    RegisterDataTreeNotificationListenerReply reply = (RegisterDataTreeNotificationListenerReply)result;
                    DataChangeListenerRegistrationProxy.this.setListenerRegistrationActor(DataChangeListenerRegistrationProxy.this.actorContext.actorSelection(reply.getListenerRegistrationPath()));
                }
            }
        }, this.actorContext.getClientDispatcher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean sendCloseMessage;
        DataChangeListenerRegistrationProxy dataChangeListenerRegistrationProxy = this;
        synchronized (dataChangeListenerRegistrationProxy) {
            sendCloseMessage = !this.closed && this.listenerRegistrationActor != null;
            this.closed = true;
        }
        if (sendCloseMessage) {
            this.listenerRegistrationActor.tell((Object)CloseDataTreeNotificationListenerRegistration.getInstance(), ActorRef.noSender());
            this.listenerRegistrationActor = null;
        }
        if (this.dataChangeListenerActor != null) {
            this.dataChangeListenerActor.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
            this.dataChangeListenerActor = null;
        }
    }
}

