/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Status;
import com.google.common.base.Preconditions;
import java.util.Collection;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.mdsal.common.api.PostCanCommitStep;
import org.opendaylight.mdsal.common.api.PostPreCommitStep;
import org.opendaylight.mdsal.common.api.ThreePhaseCommitStep;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCandidate;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

final class DataTreeCohortActor
extends AbstractUntypedActor {
    private final CohortBehaviour<?> idleState = new Idle();
    private final DOMDataTreeCommitCohort cohort;
    private final YangInstanceIdentifier registeredPath;
    private CohortBehaviour<?> currentState = this.idleState;

    private DataTreeCohortActor(DOMDataTreeCommitCohort cohort, YangInstanceIdentifier registeredPath) {
        this.cohort = (DOMDataTreeCommitCohort)Preconditions.checkNotNull((Object)cohort);
        this.registeredPath = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)registeredPath);
    }

    protected void handleReceive(Object message) {
        this.LOG.debug("handleReceive for cohort {} - currentState: {}, message: {}", new Object[]{this.cohort.getClass().getName(), this.currentState, message});
        this.currentState = this.currentState.handle(message);
    }

    static Props props(DOMDataTreeCommitCohort cohort, YangInstanceIdentifier registeredPath) {
        return Props.create(DataTreeCohortActor.class, (Object[])new Object[]{cohort, registeredPath});
    }

    private class PostPreCommit
    extends CohortStateWithStep<Commit, PostPreCommitStep> {
        PostPreCommit(TransactionIdentifier txId, PostPreCommitStep step) {
            super(DataTreeCohortActor.this, txId, (ThreePhaseCommitStep)step);
        }

        @Override
        CohortBehaviour<?> process(Commit message) {
            try {
                ((PostPreCommitStep)this.getStep()).commit().get();
            }
            catch (Exception e) {
                DataTreeCohortActor.this.getSender().tell((Object)new Status.Failure((Throwable)e), DataTreeCohortActor.this.getSender());
                return DataTreeCohortActor.this.idleState;
            }
            DataTreeCohortActor.this.getSender().tell((Object)new Success(DataTreeCohortActor.this.getSelf(), this.getTxId()), DataTreeCohortActor.this.getSelf());
            return DataTreeCohortActor.this.idleState;
        }

        @Override
        Class<Commit> getHandledMessageType() {
            return Commit.class;
        }
    }

    private class PostCanCommit
    extends CohortStateWithStep<PreCommit, PostCanCommitStep> {
        PostCanCommit(TransactionIdentifier txId, PostCanCommitStep nextStep) {
            super(DataTreeCohortActor.this, txId, (ThreePhaseCommitStep)nextStep);
        }

        @Override
        Class<PreCommit> getHandledMessageType() {
            return PreCommit.class;
        }

        @Override
        CohortBehaviour<?> process(PreCommit message) {
            PostPreCommitStep nextStep;
            try {
                nextStep = (PostPreCommitStep)((PostCanCommitStep)this.getStep()).preCommit().get();
            }
            catch (Exception e) {
                DataTreeCohortActor.this.getSender().tell((Object)new Status.Failure((Throwable)e), DataTreeCohortActor.this.getSelf());
                return DataTreeCohortActor.this.idleState;
            }
            DataTreeCohortActor.this.getSender().tell((Object)new Success(DataTreeCohortActor.this.getSelf(), message.getTxId()), DataTreeCohortActor.this.getSelf());
            return new PostPreCommit(this.getTxId(), nextStep);
        }
    }

    private static abstract class CohortStateWithStep<M extends CommitProtocolCommand<?>, S extends ThreePhaseCommitStep>
    extends CohortBehaviour<M> {
        private final S step;
        private final TransactionIdentifier txId;
        final /* synthetic */ DataTreeCohortActor this$0;

        CohortStateWithStep(TransactionIdentifier txId, S step) {
            this.this$0 = var1_1;
            this.txId = (TransactionIdentifier)Preconditions.checkNotNull((Object)txId);
            this.step = (ThreePhaseCommitStep)Preconditions.checkNotNull(step);
        }

        final S getStep() {
            return this.step;
        }

        final TransactionIdentifier getTxId() {
            return this.txId;
        }

        @Override
        final CohortBehaviour<?> abort() {
            try {
                this.getStep().abort().get();
            }
            catch (Exception e) {
                this.this$0.LOG.warn("Abort of transaction {} failed for cohort {}", new Object[]{this.txId, this.this$0.cohort, e});
                this.this$0.getSender().tell((Object)new Status.Failure((Throwable)e), this.this$0.getSelf());
                return this.this$0.idleState;
            }
            this.this$0.getSender().tell((Object)new Success(this.this$0.getSelf(), this.txId), this.this$0.getSelf());
            return this.this$0.idleState;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + " [txId=" + this.txId + ", step=" + this.step + "]";
        }
    }

    private class Idle
    extends CohortBehaviour<CanCommit> {
        private Idle() {
        }

        @Override
        Class<CanCommit> getHandledMessageType() {
            return CanCommit.class;
        }

        @Override
        CohortBehaviour<?> process(CanCommit message) {
            PostCanCommitStep nextStep;
            try {
                nextStep = (PostCanCommitStep)DataTreeCohortActor.this.cohort.canCommit((Object)message.getTxId(), message.getCandidates(), message.getSchema()).get();
            }
            catch (Exception e) {
                DataTreeCohortActor.this.getSender().tell((Object)new Status.Failure((Throwable)e), DataTreeCohortActor.this.getSelf());
                return this;
            }
            DataTreeCohortActor.this.getSender().tell((Object)new Success(DataTreeCohortActor.this.getSelf(), message.getTxId()), DataTreeCohortActor.this.getSelf());
            return new PostCanCommit(message.getTxId(), nextStep);
        }

        @Override
        CohortBehaviour<?> abort() {
            return this;
        }
    }

    private static abstract class CohortBehaviour<E> {
        private CohortBehaviour() {
        }

        abstract Class<E> getHandledMessageType();

        CohortBehaviour<?> handle(Object message) {
            if (this.getHandledMessageType().isInstance(message)) {
                return this.process(this.getHandledMessageType().cast(message));
            }
            if (message instanceof Abort) {
                return this.abort();
            }
            throw new UnsupportedOperationException(String.format("Unexpected message %s in cohort behavior %s", message.getClass(), this.getClass().getSimpleName()));
        }

        abstract CohortBehaviour<?> abort();

        abstract CohortBehaviour<?> process(E var1);

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    static final class Commit
    extends CommitProtocolCommand<Success> {
        Commit(TransactionIdentifier txId) {
            super(txId);
        }
    }

    static final class Abort
    extends CommitProtocolCommand<Success> {
        Abort(TransactionIdentifier txId) {
            super(txId);
        }
    }

    static final class PreCommit
    extends CommitProtocolCommand<Success> {
        PreCommit(TransactionIdentifier txId) {
            super(txId);
        }
    }

    static final class Success
    extends CommitReply {
        Success(ActorRef cohortRef, TransactionIdentifier txId) {
            super(cohortRef, txId);
        }
    }

    static abstract class CommitReply {
        private final ActorRef cohortRef;
        private final TransactionIdentifier txId;

        protected CommitReply(ActorRef cohortRef, TransactionIdentifier txId) {
            this.cohortRef = (ActorRef)Preconditions.checkNotNull((Object)cohortRef);
            this.txId = (TransactionIdentifier)Preconditions.checkNotNull((Object)txId);
        }

        ActorRef getCohort() {
            return this.cohortRef;
        }

        final TransactionIdentifier getTxId() {
            return this.txId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [txId=" + this.txId + ", cohortRef=" + this.cohortRef + "]";
        }
    }

    static final class CanCommit
    extends CommitProtocolCommand<Success> {
        private final Collection<DOMDataTreeCandidate> candidates;
        private final ActorRef cohort;
        private final SchemaContext schema;

        CanCommit(TransactionIdentifier txId, Collection<DOMDataTreeCandidate> candidates, SchemaContext schema, ActorRef cohort) {
            super(txId);
            this.cohort = (ActorRef)Preconditions.checkNotNull((Object)cohort);
            this.candidates = (Collection)Preconditions.checkNotNull(candidates);
            this.schema = (SchemaContext)Preconditions.checkNotNull((Object)schema);
        }

        Collection<DOMDataTreeCandidate> getCandidates() {
            return this.candidates;
        }

        SchemaContext getSchema() {
            return this.schema;
        }

        ActorRef getCohort() {
            return this.cohort;
        }

        @Override
        public String toString() {
            return "CanCommit [txId=" + this.getTxId() + ", candidates=" + this.candidates + ", cohort=" + this.cohort + "]";
        }
    }

    static abstract class CommitProtocolCommand<R extends CommitReply> {
        private final TransactionIdentifier txId;

        final TransactionIdentifier getTxId() {
            return this.txId;
        }

        protected CommitProtocolCommand(TransactionIdentifier txId) {
            this.txId = (TransactionIdentifier)Preconditions.checkNotNull((Object)txId);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [txId=" + this.txId + "]";
        }
    }
}

