/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import java.io.IOException;
import java.util.Dictionary;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.DatastoreContextIntrospector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreContextConfigAdminOverlay
implements AutoCloseable {
    public static final String CONFIG_ID = "org.opendaylight.controller.cluster.datastore";
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreContextConfigAdminOverlay.class);
    private final DatastoreContextIntrospector introspector;
    private final BundleContext bundleContext;
    private ServiceRegistration<?> configListenerServiceRef;
    private Listener listener;

    public DatastoreContextConfigAdminOverlay(DatastoreContextIntrospector introspector, BundleContext bundleContext) {
        this.introspector = introspector;
        this.bundleContext = bundleContext;
        ServiceReference configAdminServiceReference = bundleContext.getServiceReference(ConfigurationAdmin.class);
        if (configAdminServiceReference == null) {
            LOG.warn("No ConfigurationAdmin service found");
        } else {
            this.overlaySettings((ServiceReference<ConfigurationAdmin>)configAdminServiceReference);
            this.configListenerServiceRef = bundleContext.registerService(ConfigurationListener.class.getName(), (Object)new DatastoreConfigurationListener(), null);
        }
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void overlaySettings(ServiceReference<ConfigurationAdmin> configAdminServiceReference) {
        try {
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.bundleContext.getService(configAdminServiceReference);
            Configuration config = configAdmin.getConfiguration(CONFIG_ID);
            if (config != null) {
                Dictionary properties = config.getProperties();
                LOG.debug("Overlaying settings: {}", (Object)properties);
                if (this.introspector.update(properties) && this.listener != null) {
                    this.listener.onDatastoreContextUpdated(this.introspector.newContextFactory());
                }
            } else {
                LOG.debug("No Configuration found for {}", (Object)CONFIG_ID);
            }
        }
        catch (IOException e) {
            LOG.error("Error obtaining Configuration for pid {}", (Object)CONFIG_ID, (Object)e);
        }
        catch (IllegalStateException e) {
        }
        finally {
            try {
                this.bundleContext.ungetService(configAdminServiceReference);
            }
            catch (Exception e) {
                LOG.debug("Error from ungetService", (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.listener = null;
        if (this.configListenerServiceRef != null) {
            this.configListenerServiceRef.unregister();
        }
    }

    private class DatastoreConfigurationListener
    implements ConfigurationListener {
        private DatastoreConfigurationListener() {
        }

        public void configurationEvent(ConfigurationEvent event) {
            if (DatastoreContextConfigAdminOverlay.CONFIG_ID.equals(event.getPid()) && event.getType() == 1) {
                LOG.debug("configurationEvent: config {} was updated", (Object)DatastoreContextConfigAdminOverlay.CONFIG_ID);
                DatastoreContextConfigAdminOverlay.this.overlaySettings((ServiceReference<ConfigurationAdmin>)event.getReference());
            }
        }
    }

    public static interface Listener {
        public void onDatastoreContextUpdated(DatastoreContextFactory var1);
    }
}

