/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.beans.BeanInfo;
import java.beans.ConstructorProperties;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreContextIntrospector {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreContextIntrospector.class);
    private static final Map<String, Class<?>> DATA_STORE_PROP_TYPES = new HashMap();
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTORS = new HashMap();
    private static final Map<Class<?>, Method> YANG_TYPE_GETTERS = new HashMap();
    private static final Map<String, Method> BUILDER_SETTERS = new HashMap<String, Method>();
    @GuardedBy(value="this")
    private DatastoreContext context;
    @GuardedBy(value="this")
    private Map<String, Object> currentProperties;

    private static void introspectPrimitiveTypes() {
        ImmutableSet primitives = ImmutableSet.builder().addAll((Iterable)Primitives.allWrapperTypes()).add(String.class).build();
        for (Class primitive : primitives) {
            try {
                DatastoreContextIntrospector.processPropertyType(primitive);
            }
            catch (Exception exception) {}
        }
    }

    private static void introspectDatastoreContextBuilder() {
        for (Method method : DatastoreContext.Builder.class.getMethods()) {
            if (!DatastoreContext.Builder.class.equals(method.getReturnType())) continue;
            BUILDER_SETTERS.put(method.getName(), method);
        }
    }

    private static void introspectDataStoreProperties() throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(DataStoreProperties.class);
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            DatastoreContextIntrospector.processDataStoreProperty(propertyDescriptor.getName(), propertyDescriptor.getPropertyType());
        }
        for (FeatureDescriptor featureDescriptor : beanInfo.getMethodDescriptors()) {
            String methodName = featureDescriptor.getName();
            if (!Boolean.class.equals(((MethodDescriptor)featureDescriptor).getMethod().getReturnType()) || !methodName.startsWith("is")) continue;
            String propertyName = WordUtils.uncapitalize((String)methodName.substring(2));
            DatastoreContextIntrospector.processDataStoreProperty(propertyName, Boolean.class);
        }
    }

    private static void processDataStoreProperty(String name, Class<?> propertyType) {
        Preconditions.checkArgument((boolean)BUILDER_SETTERS.containsKey(name), (Object)String.format("DataStoreProperties property \"%s\" does not have corresponding setter in DatastoreContext.Builder", name));
        try {
            DatastoreContextIntrospector.processPropertyType(propertyType);
            DATA_STORE_PROP_TYPES.put(name, propertyType);
        }
        catch (Exception e) {
            LOG.error("Error finding constructor for type {}", propertyType, (Object)e);
        }
    }

    private static void processPropertyType(Class<?> propertyType) throws Exception {
        Class wrappedType = Primitives.wrap(propertyType);
        if (CONSTRUCTORS.containsKey(wrappedType)) {
            return;
        }
        if (propertyType.isPrimitive() || Primitives.isWrapperType(propertyType) || propertyType.equals(String.class)) {
            CONSTRUCTORS.put(wrappedType, propertyType.getConstructor(String.class));
        } else {
            for (Constructor<?> ctor : propertyType.getConstructors()) {
                ConstructorProperties ctorPropsAnnotation = ctor.getAnnotation(ConstructorProperties.class);
                if (ctor.getParameterTypes().length != 1 || ctorPropsAnnotation == null) continue;
                DatastoreContextIntrospector.findYangTypeGetter(propertyType, ctorPropsAnnotation.value()[0]);
                CONSTRUCTORS.put(propertyType, ctor);
                break;
            }
        }
    }

    private static void findYangTypeGetter(Class<?> type, String propertyName) throws Exception {
        for (PropertyDescriptor desc : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
            if (!desc.getName().equals(propertyName)) continue;
            YANG_TYPE_GETTERS.put(type, desc.getReadMethod());
            return;
        }
        throw new IllegalArgumentException(String.format("Getter method for constructor property %s not found for YANG type %s", propertyName, type));
    }

    public DatastoreContextIntrospector(DatastoreContext context) {
        this.context = context;
    }

    public synchronized DatastoreContext getContext() {
        return this.context;
    }

    public DatastoreContextFactory newContextFactory() {
        return new DatastoreContextFactory(this);
    }

    public synchronized DatastoreContext getShardDatastoreContext(String forShardName) {
        if (this.currentProperties == null) {
            return this.context;
        }
        DatastoreContext.Builder builder = DatastoreContext.newBuilderFrom(this.context);
        String dataStoreTypePrefix = this.context.getDataStoreName() + '.';
        String shardNamePrefix = forShardName + '.';
        ArrayList<String> keys = DatastoreContextIntrospector.getSortedKeysByDatastoreType(this.currentProperties.keySet(), dataStoreTypePrefix);
        for (String key : keys) {
            Object value = this.currentProperties.get(key);
            if (key.startsWith(dataStoreTypePrefix)) {
                key = key.replaceFirst(dataStoreTypePrefix, "");
            }
            if (!key.startsWith(shardNamePrefix)) continue;
            key = key.replaceFirst(shardNamePrefix, "");
            this.convertValueAndInvokeSetter(key, value, builder);
        }
        return builder.build();
    }

    public synchronized boolean update(Dictionary<String, Object> properties) {
        this.currentProperties = null;
        if (properties == null || properties.isEmpty()) {
            return false;
        }
        LOG.debug("In update: properties: {}", properties);
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        DatastoreContext.Builder builder = DatastoreContext.newBuilderFrom(this.context);
        String dataStoreTypePrefix = this.context.getDataStoreName() + '.';
        ArrayList<String> keys = DatastoreContextIntrospector.getSortedKeysByDatastoreType(Collections.list(properties.keys()), dataStoreTypePrefix);
        boolean updated = false;
        for (String key : keys) {
            Object value = properties.get(key);
            mapBuilder.put((Object)key, value);
            if (key.startsWith(dataStoreTypePrefix)) {
                key = key.replaceFirst(dataStoreTypePrefix, "");
            }
            if (!this.convertValueAndInvokeSetter(key, value, builder)) continue;
            updated = true;
        }
        this.currentProperties = mapBuilder.build();
        if (updated) {
            this.context = builder.build();
        }
        return updated;
    }

    private static ArrayList<String> getSortedKeysByDatastoreType(Collection<String> inKeys, String dataStoreTypePrefix) {
        ArrayList<String> keys = new ArrayList<String>(inKeys);
        Collections.sort(keys, (key1, key2) -> key1.startsWith(dataStoreTypePrefix) ? 1 : (key2.startsWith(dataStoreTypePrefix) ? -1 : key1.compareTo((String)key2)));
        return keys;
    }

    private boolean convertValueAndInvokeSetter(String inKey, Object inValue, DatastoreContext.Builder builder) {
        String key = DatastoreContextIntrospector.convertToCamelCase(inKey);
        try {
            Object value = this.convertValue(key, inValue);
            if (value == null) {
                return false;
            }
            LOG.debug("Converted value for property {}: {} ({})", new Object[]{key, value, value.getClass().getSimpleName()});
            Method setter = BUILDER_SETTERS.get(key);
            setter.invoke((Object)builder, this.constructorValueRecursively(Primitives.wrap(setter.getParameterTypes()[0]), value.toString()));
            return true;
        }
        catch (Exception e) {
            LOG.error("Error converting value ({}) for property {}", new Object[]{inValue, key, e});
            return false;
        }
    }

    private static String convertToCamelCase(String inString) {
        String str = inString.trim();
        if (StringUtils.contains((CharSequence)str, (int)45) || StringUtils.contains((CharSequence)str, (int)32)) {
            str = inString.replace('-', ' ');
            str = WordUtils.capitalizeFully((String)str);
            str = StringUtils.deleteWhitespace((String)str);
        }
        return StringUtils.uncapitalize((String)str);
    }

    private Object convertValue(String name, Object from) throws Exception {
        Class<?> propertyType = DATA_STORE_PROP_TYPES.get(name);
        if (propertyType == null) {
            LOG.debug("Property not found for {}", (Object)name);
            return null;
        }
        LOG.debug("Type for property {}: {}, converting value {} ({})", new Object[]{name, propertyType.getSimpleName(), from, from.getClass().getSimpleName()});
        Object converted = this.constructorValueRecursively(propertyType, from.toString());
        Method getter = YANG_TYPE_GETTERS.get(converted.getClass());
        if (getter != null) {
            converted = getter.invoke(converted, new Object[0]);
        }
        return converted;
    }

    private Object constructorValueRecursively(Class<?> toType, Object fromValue) throws Exception {
        LOG.trace("convertValueRecursively - toType: {}, fromValue {} ({})", new Object[]{toType.getSimpleName(), fromValue, fromValue.getClass().getSimpleName()});
        Constructor<?> ctor = CONSTRUCTORS.get(toType);
        LOG.trace("Found {}", ctor);
        if (ctor == null) {
            throw new IllegalArgumentException(String.format("Constructor not found for type %s", toType));
        }
        Object value = fromValue;
        if (!ctor.getParameterTypes()[0].equals(String.class)) {
            value = this.constructorValueRecursively(ctor.getParameterTypes()[0], fromValue);
        }
        return ctor.newInstance(value);
    }

    static {
        try {
            DatastoreContextIntrospector.introspectDatastoreContextBuilder();
            DatastoreContextIntrospector.introspectDataStoreProperties();
            DatastoreContextIntrospector.introspectPrimitiveTypes();
        }
        catch (IntrospectionException e) {
            LOG.error("Error initializing DatastoreContextIntrospector", (Throwable)e);
        }
    }
}

