/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Optional;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.cluster.datastore.ShardDataChangeListenerPublisher;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeEvent;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeListener;
import org.opendaylight.controller.md.sal.dom.store.impl.DOMImmutableDataChangeEvent;
import org.opendaylight.controller.md.sal.dom.store.impl.DataChangeListenerRegistration;
import org.opendaylight.controller.md.sal.dom.store.impl.ResolveDataChangeEventsTask;
import org.opendaylight.controller.md.sal.dom.store.impl.tree.ListenerTree;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.concurrent.NotificationManager;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class DefaultShardDataChangeListenerPublisher
implements ShardDataChangeListenerPublisher,
NotificationManager<DataChangeListenerRegistration<?>, DOMImmutableDataChangeEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultShardDataChangeListenerPublisher.class);
    private final ListenerTree dataChangeListenerTree = ListenerTree.create();
    private final String logContext;

    DefaultShardDataChangeListenerPublisher(String logContext) {
        this.logContext = logContext;
    }

    public void submitNotification(DataChangeListenerRegistration<?> listener, DOMImmutableDataChangeEvent notification) {
        LOG.debug("{}: Notifying listener {} about {}", new Object[]{this.logContext, listener.getInstance(), notification});
        listener.getInstance().onDataChanged((AsyncDataChangeEvent)notification);
    }

    public void submitNotifications(DataChangeListenerRegistration<?> listener, Iterable<DOMImmutableDataChangeEvent> notifications) {
        AsyncDataChangeListener instance = listener.getInstance();
        LOG.debug("{}: Notifying listener {} about {}", new Object[]{this.logContext, instance, notifications});
        for (DOMImmutableDataChangeEvent n : notifications) {
            instance.onDataChanged((AsyncDataChangeEvent)n);
        }
    }

    @Override
    public void publishChanges(DataTreeCandidate candidate) {
        ResolveDataChangeEventsTask.create((DataTreeCandidate)candidate, (ListenerTree)this.dataChangeListenerTree).resolve((NotificationManager)this);
    }

    @Override
    public void registerDataChangeListener(YangInstanceIdentifier path, AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>> listener, AsyncDataBroker.DataChangeScope scope, Optional<DataTreeCandidate> initialState, Consumer<ListenerRegistration<AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>>>> onRegistration) {
        DataChangeListenerRegistration registration = this.dataChangeListenerTree.registerDataChangeListener(path, listener, scope);
        onRegistration.accept((ListenerRegistration<AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>>>)registration);
        if (initialState.isPresent()) {
            DefaultShardDataChangeListenerPublisher.notifySingleListener(path, listener, scope, (DataTreeCandidate)initialState.get(), this.logContext);
        }
    }

    static void notifySingleListener(YangInstanceIdentifier path, AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>> listener, AsyncDataBroker.DataChangeScope scope, DataTreeCandidate initialState, String logContext) {
        DefaultShardDataChangeListenerPublisher publisher = new DefaultShardDataChangeListenerPublisher(logContext);
        publisher.registerDataChangeListener(path, listener, scope, (Optional<DataTreeCandidate>)Optional.absent(), noop -> {});
        publisher.publishChanges(initialState);
    }
}

