/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeChangeListenerPublisher;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.spi.AbstractDOMDataTreeChangeListenerRegistration;
import org.opendaylight.mdsal.dom.spi.store.AbstractDOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
final class DefaultShardDataTreeChangeListenerPublisher
extends AbstractDOMStoreTreeChangePublisher
implements ShardDataTreeChangeListenerPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultShardDataTreeChangeListenerPublisher.class);
    private String logContext;

    DefaultShardDataTreeChangeListenerPublisher(String logContext) {
        this.logContext = logContext;
    }

    @Override
    public void publishChanges(DataTreeCandidate candidate) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: publishChanges: {}", (Object)this.logContext, (Object)candidate);
        } else {
            LOG.debug("{}: publishChanges: rootPath: {}", (Object)this.logContext, (Object)candidate.getRootPath());
        }
        this.processCandidateTree(candidate);
    }

    protected void notifyListener(AbstractDOMDataTreeChangeListenerRegistration<?> registration, Collection<DataTreeCandidate> changes) {
        LOG.debug("{}: notifyListener: listener: {}", (Object)this.logContext, registration.getInstance());
        ((org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener)registration.getInstance()).onDataTreeChanged(changes);
    }

    protected void registrationRemoved(AbstractDOMDataTreeChangeListenerRegistration<?> registration) {
        LOG.debug("Registration {} removed", registration);
    }

    @Override
    public void registerTreeChangeListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener, Optional<DataTreeCandidate> initialState, Consumer<ListenerRegistration<DOMDataTreeChangeListener>> onRegistration) {
        LOG.debug("{}: registerTreeChangeListener: path: {}, listener: {}", new Object[]{this.logContext, treeId, listener});
        final AbstractDOMDataTreeChangeListenerRegistration registration = super.registerTreeChangeListener(treeId, (org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener)new ForwardingDOMDataTreeChangeListener(listener));
        onRegistration.accept((ListenerRegistration<DOMDataTreeChangeListener>)new org.opendaylight.controller.md.sal.dom.spi.AbstractDOMDataTreeChangeListenerRegistration<DOMDataTreeChangeListener>(listener){

            protected void removeRegistration() {
                registration.close();
            }
        });
        if (initialState.isPresent()) {
            DefaultShardDataTreeChangeListenerPublisher.notifySingleListener(treeId, listener, (DataTreeCandidate)initialState.get(), this.logContext);
        }
    }

    static void notifySingleListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener, DataTreeCandidate state, String logContext) {
        LOG.debug("{}: notifySingleListener: path: {}, listener: {}", new Object[]{logContext, treeId, listener});
        DefaultShardDataTreeChangeListenerPublisher publisher = new DefaultShardDataTreeChangeListenerPublisher(logContext);
        publisher.logContext = logContext;
        publisher.registerTreeChangeListener(treeId, listener, (Optional<DataTreeCandidate>)Optional.absent(), noop -> {});
        publisher.publishChanges(state);
    }

    private static class ForwardingDOMDataTreeChangeListener
    implements org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener {
        final DOMDataTreeChangeListener delegate;

        ForwardingDOMDataTreeChangeListener(DOMDataTreeChangeListener delegate) {
            this.delegate = delegate;
        }

        public void onDataTreeChanged(Collection<DataTreeCandidate> changes) {
            this.delegate.onDataTreeChanged(changes);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

