/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import java.util.EventListener;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.cluster.datastore.AbstractDataListenerSupport;
import org.opendaylight.controller.cluster.datastore.messages.ListenerRegistrationMessage;
import org.opendaylight.yangtools.concepts.ListenerRegistration;

class DelayedListenerRegistration<L extends EventListener, M extends ListenerRegistrationMessage>
implements ListenerRegistration<L> {
    private final M registrationMessage;
    private final ActorRef registrationActor;
    @GuardedBy(value="this")
    private boolean closed;

    protected DelayedListenerRegistration(M registrationMessage, ActorRef registrationActor) {
        this.registrationMessage = registrationMessage;
        this.registrationActor = registrationActor;
    }

    M getRegistrationMessage() {
        return this.registrationMessage;
    }

    synchronized void doRegistration(AbstractDataListenerSupport<L, M> support) {
        if (!this.closed) {
            support.doRegistration(this.registrationMessage, this.registrationActor);
        }
    }

    public L getInstance() {
        throw new UnsupportedOperationException("getInstance should not be called on this instance since it could be null");
    }

    public synchronized void close() {
        this.closed = true;
    }
}

