/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSystem;
import com.google.common.annotations.VisibleForTesting;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.TransactionContextFactory;
import org.opendaylight.controller.cluster.datastore.TransactionProxy;
import org.opendaylight.controller.cluster.datastore.TransactionType;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransactionChain;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction;

public class DistributedDataStore
extends AbstractDataStore {
    private final TransactionContextFactory txContextFactory = new TransactionContextFactory(this.getActorContext(), this.getIdentifier());

    public DistributedDataStore(ActorSystem actorSystem, ClusterWrapper cluster, Configuration configuration, DatastoreContextFactory datastoreContextFactory, DatastoreSnapshot restoreFromSnapshot) {
        super(actorSystem, cluster, configuration, datastoreContextFactory, restoreFromSnapshot);
    }

    @VisibleForTesting
    DistributedDataStore(ActorContext actorContext, ClientIdentifier identifier) {
        super(actorContext, identifier);
    }

    public DOMStoreTransactionChain createTransactionChain() {
        return this.txContextFactory.createTransactionChain();
    }

    public DOMStoreReadTransaction newReadOnlyTransaction() {
        return new TransactionProxy(this.txContextFactory, TransactionType.READ_ONLY);
    }

    public DOMStoreWriteTransaction newWriteOnlyTransaction() {
        this.getActorContext().acquireTxCreationPermit();
        return new TransactionProxy(this.txContextFactory, TransactionType.WRITE_ONLY);
    }

    public DOMStoreReadWriteTransaction newReadWriteTransaction() {
        this.getActorContext().acquireTxCreationPermit();
        return new TransactionProxy(this.txContextFactory, TransactionType.READ_WRITE);
    }

    @Override
    public void close() {
        this.txContextFactory.close();
        super.close();
    }
}

