/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSystem;
import org.opendaylight.controller.cluster.ActorSystemProvider;
import org.opendaylight.controller.cluster.databroker.ClientBackedDataStore;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.ClusterWrapperImpl;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextConfigAdminOverlay;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.DatastoreContextIntrospector;
import org.opendaylight.controller.cluster.datastore.DatastoreSnapshotRestore;
import org.opendaylight.controller.cluster.datastore.DistributedDataStore;
import org.opendaylight.controller.cluster.datastore.config.ConfigurationImpl;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.sal.core.api.model.SchemaService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedDataStoreFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedDataStoreFactory.class);

    @Deprecated
    public static AbstractDataStore createInstance(SchemaService schemaService, DatastoreContext initialDatastoreContext, DatastoreSnapshotRestore datastoreSnapshotRestore, ActorSystemProvider actorSystemProvider, BundleContext bundleContext) {
        return DistributedDataStoreFactory.createInstance((DOMSchemaService)schemaService, initialDatastoreContext, datastoreSnapshotRestore, actorSystemProvider, bundleContext);
    }

    public static AbstractDataStore createInstance(DOMSchemaService schemaService, DatastoreContext initialDatastoreContext, DatastoreSnapshotRestore datastoreSnapshotRestore, ActorSystemProvider actorSystemProvider, BundleContext bundleContext) {
        AbstractDataStore dataStore;
        String datastoreName = initialDatastoreContext.getDataStoreName();
        LOG.info("Create data store instance of type : {}", (Object)datastoreName);
        ActorSystem actorSystem = actorSystemProvider.getActorSystem();
        DatastoreSnapshot restoreFromSnapshot = datastoreSnapshotRestore.getAndRemove(datastoreName);
        DatastoreContextIntrospector introspector = new DatastoreContextIntrospector(initialDatastoreContext);
        DatastoreContextConfigAdminOverlay overlay = new DatastoreContextConfigAdminOverlay(introspector, bundleContext);
        ConfigurationImpl config = new ConfigurationImpl("module-shards.conf", "modules.conf");
        ClusterWrapperImpl clusterWrapper = new ClusterWrapperImpl(actorSystem);
        DatastoreContextFactory contextFactory = introspector.newContextFactory();
        DatastoreContext datastoreContext = contextFactory.getBaseDatastoreContext();
        if (datastoreContext.isUseTellBasedProtocol()) {
            dataStore = new ClientBackedDataStore(actorSystem, clusterWrapper, config, contextFactory, restoreFromSnapshot);
            LOG.info("Data store {} is using tell-based protocol", (Object)datastoreName);
        } else {
            dataStore = new DistributedDataStore(actorSystem, clusterWrapper, config, contextFactory, restoreFromSnapshot);
            LOG.info("Data store {} is using ask-based protocol", (Object)datastoreName);
        }
        overlay.setListener(dataStore);
        schemaService.registerSchemaContextListener((SchemaContextListener)dataStore);
        dataStore.setCloseable(overlay);
        dataStore.waitTillReady();
        return dataStore;
    }
}

