/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import com.google.common.base.Preconditions;
import java.util.Collection;
import org.opendaylight.controller.cluster.datastore.messages.DataTreeChanged;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ForwardingDataTreeChangeListener
implements DOMDataTreeChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardingDataTreeChangeListener.class);
    private final ActorSelection actor;

    ForwardingDataTreeChangeListener(ActorSelection actor) {
        this.actor = (ActorSelection)Preconditions.checkNotNull((Object)actor, (Object)"actor should not be null");
    }

    public void onDataTreeChanged(Collection<DataTreeCandidate> changes) {
        LOG.debug("Sending DataTreeChanged to {}", (Object)this.actor);
        this.actor.tell((Object)new DataTreeChanged(changes), ActorRef.noSender());
    }

    public String toString() {
        return "ForwardingDataTreeChangeListener [actor=" + this.actor + "]";
    }
}

