/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import akka.dispatch.Futures;
import akka.dispatch.OnComplete;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.TransactionReadyReplyMapper;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.ReadyLocalTransaction;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.sal.core.spi.data.SnapshotBackedWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Future;

class LocalThreePhaseCommitCohort
implements DOMStoreThreePhaseCommitCohort {
    private static final Logger LOG = LoggerFactory.getLogger(LocalThreePhaseCommitCohort.class);
    private final SnapshotBackedWriteTransaction<TransactionIdentifier> transaction;
    private final DataTreeModification modification;
    private final ActorContext actorContext;
    private final ActorSelection leader;
    private final Exception operationError;

    protected LocalThreePhaseCommitCohort(ActorContext actorContext, ActorSelection leader, SnapshotBackedWriteTransaction<TransactionIdentifier> transaction, DataTreeModification modification) {
        this.actorContext = (ActorContext)Preconditions.checkNotNull((Object)actorContext);
        this.leader = (ActorSelection)Preconditions.checkNotNull((Object)leader);
        this.transaction = (SnapshotBackedWriteTransaction)Preconditions.checkNotNull(transaction);
        this.modification = (DataTreeModification)Preconditions.checkNotNull((Object)modification);
        this.operationError = null;
    }

    protected LocalThreePhaseCommitCohort(ActorContext actorContext, ActorSelection leader, SnapshotBackedWriteTransaction<TransactionIdentifier> transaction, Exception operationError) {
        this.actorContext = (ActorContext)Preconditions.checkNotNull((Object)actorContext);
        this.leader = (ActorSelection)Preconditions.checkNotNull((Object)leader);
        this.transaction = (SnapshotBackedWriteTransaction)Preconditions.checkNotNull(transaction);
        this.operationError = (Exception)Preconditions.checkNotNull((Object)operationError);
        this.modification = null;
    }

    private Future<Object> initiateCommit(boolean immediate) {
        if (this.operationError != null) {
            return Futures.failed((Throwable)this.operationError);
        }
        ReadyLocalTransaction message = new ReadyLocalTransaction((TransactionIdentifier)this.transaction.getIdentifier(), this.modification, immediate);
        return this.actorContext.executeOperationAsync(this.leader, (Object)message, this.actorContext.getTransactionCommitOperationTimeout());
    }

    Future<ActorSelection> initiateCoordinatedCommit() {
        Future<Object> messageFuture = this.initiateCommit(false);
        Future<ActorSelection> ret = TransactionReadyReplyMapper.transform(messageFuture, this.actorContext, (TransactionIdentifier)this.transaction.getIdentifier());
        ret.onComplete((Function1)new OnComplete<ActorSelection>(){

            public void onComplete(Throwable failure, ActorSelection success) throws Throwable {
                if (failure != null) {
                    LOG.info("Failed to prepare transaction {} on backend", LocalThreePhaseCommitCohort.this.transaction.getIdentifier(), (Object)failure);
                    LocalThreePhaseCommitCohort.this.transactionAborted((SnapshotBackedWriteTransaction<TransactionIdentifier>)LocalThreePhaseCommitCohort.this.transaction);
                    return;
                }
                LOG.debug("Transaction {} resolved to actor {}", LocalThreePhaseCommitCohort.this.transaction.getIdentifier(), (Object)success);
            }
        }, this.actorContext.getClientDispatcher());
        return ret;
    }

    Future<Object> initiateDirectCommit() {
        Future<Object> messageFuture = this.initiateCommit(true);
        messageFuture.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object message) throws Throwable {
                if (failure != null) {
                    LOG.error("Failed to prepare transaction {} on backend", LocalThreePhaseCommitCohort.this.transaction.getIdentifier(), (Object)failure);
                    LocalThreePhaseCommitCohort.this.transactionAborted((SnapshotBackedWriteTransaction<TransactionIdentifier>)LocalThreePhaseCommitCohort.this.transaction);
                } else if (CommitTransactionReply.isSerializedType(message)) {
                    LOG.debug("Transaction {} committed successfully", LocalThreePhaseCommitCohort.this.transaction.getIdentifier());
                    LocalThreePhaseCommitCohort.this.transactionCommitted((SnapshotBackedWriteTransaction<TransactionIdentifier>)LocalThreePhaseCommitCohort.this.transaction);
                } else {
                    LOG.error("Transaction {} resulted in unhandled message type {}, aborting", message.getClass());
                    LocalThreePhaseCommitCohort.this.transactionAborted((SnapshotBackedWriteTransaction<TransactionIdentifier>)LocalThreePhaseCommitCohort.this.transaction);
                }
            }
        }, this.actorContext.getClientDispatcher());
        return messageFuture;
    }

    public final ListenableFuture<Boolean> canCommit() {
        throw new UnsupportedOperationException();
    }

    public final ListenableFuture<Void> preCommit() {
        throw new UnsupportedOperationException();
    }

    public final ListenableFuture<Void> abort() {
        throw new UnsupportedOperationException();
    }

    public final ListenableFuture<Void> commit() {
        throw new UnsupportedOperationException();
    }

    protected void transactionAborted(SnapshotBackedWriteTransaction<TransactionIdentifier> aborted) {
    }

    protected void transactionCommitted(SnapshotBackedWriteTransaction<TransactionIdentifier> comitted) {
    }
}

