/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.LocalThreePhaseCommitCohort;
import org.opendaylight.controller.cluster.datastore.LocalTransactionFactory;
import org.opendaylight.controller.cluster.datastore.TransactionChainProxy;
import org.opendaylight.controller.sal.core.spi.data.AbstractSnapshotBackedTransactionChain;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.SnapshotBackedWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;

final class LocalTransactionChain
extends AbstractSnapshotBackedTransactionChain<TransactionIdentifier>
implements LocalTransactionFactory {
    private static final Throwable ABORTED = new Throwable("Transaction aborted");
    private final TransactionChainProxy parent;
    private final ActorSelection leader;
    private final DataTree tree;

    LocalTransactionChain(TransactionChainProxy parent, ActorSelection leader, DataTree tree) {
        this.parent = (TransactionChainProxy)Preconditions.checkNotNull((Object)parent);
        this.leader = (ActorSelection)Preconditions.checkNotNull((Object)leader);
        this.tree = (DataTree)Preconditions.checkNotNull((Object)tree);
    }

    DataTree getDataTree() {
        return this.tree;
    }

    protected TransactionIdentifier nextTransactionIdentifier() {
        throw new UnsupportedOperationException();
    }

    protected boolean getDebugTransactions() {
        return false;
    }

    protected DataTreeSnapshot takeSnapshot() {
        return this.tree.takeSnapshot();
    }

    protected DOMStoreThreePhaseCommitCohort createCohort(SnapshotBackedWriteTransaction<TransactionIdentifier> transaction, DataTreeModification modification) {
        return new LocalChainThreePhaseCommitCohort(transaction, modification);
    }

    @Override
    public DOMStoreReadTransaction newReadOnlyTransaction(TransactionIdentifier identifier) {
        return super.newReadOnlyTransaction((Object)identifier);
    }

    @Override
    public DOMStoreReadWriteTransaction newReadWriteTransaction(TransactionIdentifier identifier) {
        return super.newReadWriteTransaction((Object)identifier);
    }

    @Override
    public DOMStoreWriteTransaction newWriteOnlyTransaction(TransactionIdentifier identifier) {
        return super.newWriteOnlyTransaction((Object)identifier);
    }

    @Override
    public LocalThreePhaseCommitCohort onTransactionReady(@Nonnull DOMStoreWriteTransaction tx, @Nullable Exception operationError) {
        Preconditions.checkArgument((boolean)(tx instanceof SnapshotBackedWriteTransaction));
        if (operationError != null) {
            return new LocalChainThreePhaseCommitCohort((SnapshotBackedWriteTransaction<TransactionIdentifier>)((SnapshotBackedWriteTransaction)tx), operationError);
        }
        try {
            return (LocalThreePhaseCommitCohort)tx.ready();
        }
        catch (Exception e) {
            return new LocalChainThreePhaseCommitCohort((SnapshotBackedWriteTransaction<TransactionIdentifier>)((SnapshotBackedWriteTransaction)tx), e);
        }
    }

    private class LocalChainThreePhaseCommitCohort
    extends LocalThreePhaseCommitCohort {
        protected LocalChainThreePhaseCommitCohort(SnapshotBackedWriteTransaction<TransactionIdentifier> transaction, DataTreeModification modification) {
            super(LocalTransactionChain.this.parent.getActorContext(), LocalTransactionChain.this.leader, transaction, modification);
        }

        protected LocalChainThreePhaseCommitCohort(SnapshotBackedWriteTransaction<TransactionIdentifier> transaction, Exception operationError) {
            super(LocalTransactionChain.this.parent.getActorContext(), LocalTransactionChain.this.leader, transaction, operationError);
        }

        @Override
        protected void transactionAborted(SnapshotBackedWriteTransaction<TransactionIdentifier> transaction) {
            LocalTransactionChain.this.onTransactionFailed(transaction, ABORTED);
        }

        @Override
        protected void transactionCommitted(SnapshotBackedWriteTransaction<TransactionIdentifier> transaction) {
            LocalTransactionChain.this.onTransactionCommited(transaction);
        }
    }
}

