/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import akka.dispatch.Futures;
import com.google.common.util.concurrent.SettableFuture;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTransactionContext;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.messages.AbstractRead;
import org.opendaylight.controller.cluster.datastore.modification.AbstractModification;
import org.opendaylight.controller.md.sal.common.api.data.DataStoreUnavailableException;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Future;

final class NoOpTransactionContext
extends AbstractTransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(NoOpTransactionContext.class);
    private final Throwable failure;

    NoOpTransactionContext(Throwable failure, TransactionIdentifier identifier) {
        super(identifier);
        this.failure = failure;
    }

    @Override
    public void closeTransaction() {
        LOG.debug("NoOpTransactionContext {} closeTransaction called", (Object)this.getIdentifier());
    }

    @Override
    public Future<Object> directCommit() {
        LOG.debug("Tx {} directCommit called, failure: {}", (Object)this.getIdentifier(), (Object)this.failure);
        return Futures.failed((Throwable)this.failure);
    }

    @Override
    public Future<ActorSelection> readyTransaction() {
        LOG.debug("Tx {} readyTransaction called, failure: {}", (Object)this.getIdentifier(), (Object)this.failure);
        return Futures.failed((Throwable)this.failure);
    }

    @Override
    public void executeModification(AbstractModification modification) {
        LOG.debug("Tx {} executeModification {} called path = {}", new Object[]{this.getIdentifier(), modification.getClass().getSimpleName(), modification.getPath()});
    }

    @Override
    public <T> void executeRead(AbstractRead<T> readCmd, SettableFuture<T> proxyFuture) {
        LOG.debug("Tx {} executeRead {} called path = {}", new Object[]{this.getIdentifier(), readCmd.getClass().getSimpleName(), readCmd.getPath()});
        Throwable t = this.failure instanceof NoShardLeaderException ? new DataStoreUnavailableException(this.failure.getMessage(), this.failure) : this.failure;
        proxyFuture.setException((Throwable)new ReadFailedException("Error executeRead " + readCmd.getClass().getSimpleName() + " for path " + readCmd.getPath(), t, new RpcError[0]));
    }
}

