/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import akka.dispatch.OnComplete;
import akka.util.Timeout;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractTransactionContext;
import org.opendaylight.controller.cluster.datastore.OperationLimiter;
import org.opendaylight.controller.cluster.datastore.TransactionContextCleanup;
import org.opendaylight.controller.cluster.datastore.TransactionReadyReplyMapper;
import org.opendaylight.controller.cluster.datastore.messages.AbstractRead;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.CloseTransaction;
import org.opendaylight.controller.cluster.datastore.messages.SerializableMessage;
import org.opendaylight.controller.cluster.datastore.modification.AbstractModification;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Future;

public class RemoteTransactionContext
extends AbstractTransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteTransactionContext.class);
    private final ActorContext actorContext;
    private final ActorSelection actor;
    private final OperationLimiter limiter;
    private BatchedModifications batchedModifications;
    private int totalBatchedModificationsSent;

    protected RemoteTransactionContext(TransactionIdentifier identifier, ActorSelection actor, ActorContext actorContext, short remoteTransactionVersion, OperationLimiter limiter) {
        super(identifier, remoteTransactionVersion);
        this.limiter = (OperationLimiter)((Object)Preconditions.checkNotNull((Object)((Object)limiter)));
        this.actor = actor;
        this.actorContext = actorContext;
    }

    private Future<Object> completeOperation(Future<Object> operationFuture) {
        operationFuture.onComplete((Function1)this.limiter, this.actorContext.getClientDispatcher());
        return operationFuture;
    }

    private ActorSelection getActor() {
        return this.actor;
    }

    protected ActorContext getActorContext() {
        return this.actorContext;
    }

    protected Future<Object> executeOperationAsync(SerializableMessage msg, Timeout timeout) {
        return this.completeOperation(this.actorContext.executeOperationAsync(this.getActor(), msg.toSerializable(), timeout));
    }

    @Override
    public void closeTransaction() {
        LOG.debug("Tx {} closeTransaction called", (Object)this.getIdentifier());
        TransactionContextCleanup.untrack(this);
        this.actorContext.sendOperationAsync(this.getActor(), new CloseTransaction(this.getTransactionVersion()).toSerializable());
    }

    @Override
    public Future<Object> directCommit() {
        LOG.debug("Tx {} directCommit called", (Object)this.getIdentifier());
        return this.sendBatchedModifications(true, true);
    }

    @Override
    public Future<ActorSelection> readyTransaction() {
        this.logModificationCount();
        LOG.debug("Tx {} readyTransaction called", (Object)this.getIdentifier());
        Future<Object> lastModificationsFuture = this.sendBatchedModifications(true, false);
        return this.transformReadyReply(lastModificationsFuture);
    }

    protected Future<ActorSelection> transformReadyReply(Future<Object> readyReplyFuture) {
        return TransactionReadyReplyMapper.transform(readyReplyFuture, this.actorContext, this.getIdentifier());
    }

    private BatchedModifications newBatchedModifications() {
        return new BatchedModifications(this.getIdentifier(), this.getTransactionVersion());
    }

    private void batchModification(Modification modification) {
        this.incrementModificationCount();
        if (this.batchedModifications == null) {
            this.batchedModifications = this.newBatchedModifications();
        }
        this.batchedModifications.addModification(modification);
        if (this.batchedModifications.getModifications().size() >= this.actorContext.getDatastoreContext().getShardBatchedModificationCount()) {
            this.sendBatchedModifications();
        }
    }

    protected Future<Object> sendBatchedModifications() {
        return this.sendBatchedModifications(false, false);
    }

    protected Future<Object> sendBatchedModifications(boolean ready, boolean doCommitOnReady) {
        Future<Object> sent = null;
        if (ready || this.batchedModifications != null && !this.batchedModifications.getModifications().isEmpty()) {
            if (this.batchedModifications == null) {
                this.batchedModifications = this.newBatchedModifications();
            }
            LOG.debug("Tx {} sending {} batched modifications, ready: {}", new Object[]{this.getIdentifier(), this.batchedModifications.getModifications().size(), ready});
            this.batchedModifications.setReady(ready);
            this.batchedModifications.setDoCommitOnReady(doCommitOnReady);
            this.batchedModifications.setTotalMessagesSent(++this.totalBatchedModificationsSent);
            BatchedModifications toSend = this.batchedModifications;
            this.batchedModifications = ready ? null : this.newBatchedModifications();
            sent = this.executeOperationAsync(toSend, this.actorContext.getTransactionCommitOperationTimeout());
        }
        return sent;
    }

    @Override
    public void executeModification(AbstractModification modification) {
        LOG.debug("Tx {} executeModification {} called path = {}", new Object[]{this.getIdentifier(), modification.getClass().getSimpleName(), modification.getPath()});
        this.acquireOperation();
        this.batchModification(modification);
    }

    @Override
    public <T> void executeRead(final AbstractRead<T> readCmd, final SettableFuture<T> returnFuture) {
        LOG.debug("Tx {} executeRead {} called path = {}", new Object[]{this.getIdentifier(), readCmd.getClass().getSimpleName(), readCmd.getPath()});
        this.acquireOperation();
        this.sendBatchedModifications();
        OnComplete<Object> onComplete = new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) throws Throwable {
                if (failure != null) {
                    LOG.debug("Tx {} {} operation failed: {}", new Object[]{RemoteTransactionContext.this.getIdentifier(), readCmd.getClass().getSimpleName(), failure});
                    returnFuture.setException((Throwable)new ReadFailedException("Error checking " + readCmd.getClass().getSimpleName() + " for path " + readCmd.getPath(), failure, new RpcError[0]));
                } else {
                    LOG.debug("Tx {} {} operation succeeded", (Object)RemoteTransactionContext.this.getIdentifier(), (Object)readCmd.getClass().getSimpleName());
                    readCmd.processResponse(response, returnFuture);
                }
            }
        };
        Future<Object> future = this.executeOperationAsync(readCmd.asVersion(this.getTransactionVersion()), this.actorContext.getOperationTimeout());
        future.onComplete((Function1)onComplete, this.actorContext.getClientDispatcher());
    }

    private void acquireOperation() {
        if (this.isOperationHandOffComplete()) {
            this.limiter.acquire();
        }
    }

    @Override
    public boolean usesOperationLimiting() {
        return true;
    }
}

