/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.Props;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import org.opendaylight.controller.cluster.datastore.DefaultShardDataChangeListenerPublisher;
import org.opendaylight.controller.cluster.datastore.ShardDataChangeListenerPublisher;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeNotificationPublisherActor;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataBroker;
import org.opendaylight.controller.md.sal.common.api.data.AsyncDataChangeListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

public class ShardDataChangePublisherActor
extends ShardDataTreeNotificationPublisherActor<ShardDataChangeListenerPublisher> {
    private ShardDataChangePublisherActor(String name, String logContext) {
        super(new DefaultShardDataChangeListenerPublisher(logContext), name, logContext);
    }

    @Override
    protected void handleReceive(Object message) {
        if (message instanceof RegisterListener) {
            RegisterListener reg = (RegisterListener)message;
            if (reg.initialState.isPresent()) {
                DefaultShardDataChangeListenerPublisher.notifySingleListener(reg.path, reg.listener, reg.scope, (DataTreeCandidate)reg.initialState.get(), this.logContext());
            }
            ((ShardDataChangeListenerPublisher)this.publisher()).registerDataChangeListener(reg.path, reg.listener, reg.scope, (Optional<DataTreeCandidate>)Optional.absent(), reg.onRegistration);
        } else {
            super.handleReceive(message);
        }
    }

    static Props props(String name, String logContext) {
        return Props.create(ShardDataChangePublisherActor.class, (Object[])new Object[]{name, logContext});
    }

    static class RegisterListener {
        private final YangInstanceIdentifier path;
        private final AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>> listener;
        private final AsyncDataBroker.DataChangeScope scope;
        private final Optional<DataTreeCandidate> initialState;
        private final Consumer<ListenerRegistration<AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>>>> onRegistration;

        RegisterListener(YangInstanceIdentifier path, AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>> listener, AsyncDataBroker.DataChangeScope scope, Optional<DataTreeCandidate> initialState, Consumer<ListenerRegistration<AsyncDataChangeListener<YangInstanceIdentifier, NormalizedNode<?, ?>>>> onRegistration) {
            this.path = (YangInstanceIdentifier)Preconditions.checkNotNull((Object)path);
            this.listener = (AsyncDataChangeListener)Preconditions.checkNotNull(listener);
            this.scope = (AsyncDataBroker.DataChangeScope)Preconditions.checkNotNull((Object)scope);
            this.initialState = (Optional)Preconditions.checkNotNull(initialState);
            this.onRegistration = (Consumer)Preconditions.checkNotNull(onRegistration);
        }
    }
}

