/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.Preconditions;
import java.io.File;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.persisted.ShardDataTreeSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardSnapshotState;
import org.opendaylight.controller.cluster.datastore.utils.NormalizedNodeXMLOutput;
import org.opendaylight.controller.cluster.raft.RaftActorRecoveryCohort;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.Payload;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;

class ShardRecoveryCoordinator
implements RaftActorRecoveryCohort {
    private final ShardDataTree store;
    private final String shardName;
    private final Logger log;
    private final Snapshot restoreFromSnapshot;
    private boolean open;

    ShardRecoveryCoordinator(ShardDataTree store, Snapshot restoreFromSnapshot, String shardName, Logger log) {
        this.store = (ShardDataTree)Preconditions.checkNotNull((Object)store);
        this.shardName = (String)Preconditions.checkNotNull((Object)shardName);
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
        this.restoreFromSnapshot = restoreFromSnapshot;
    }

    public void startLogRecoveryBatch(int maxBatchSize) {
        this.log.debug("{}: starting log recovery batch with max size {}", (Object)this.shardName, (Object)maxBatchSize);
        this.open = true;
    }

    public void appendRecoveredLogEntry(Payload payload) {
        Preconditions.checkState((boolean)this.open, (Object)"call startLogRecovery before calling appendRecoveredLogEntry");
        try {
            this.store.applyRecoveryPayload(payload);
        }
        catch (Exception e) {
            this.log.error("{}: failed to apply payload {}", new Object[]{this.shardName, payload, e});
            throw new IllegalStateException(String.format("%s: Failed to apply recovery payload %s", this.shardName, payload), e);
        }
    }

    public void applyCurrentLogRecoveryBatch() {
        Preconditions.checkState((boolean)this.open, (Object)"call startLogRecovery before calling applyCurrentLogRecoveryBatch");
        this.open = false;
    }

    private File writeRoot(String kind, NormalizedNode<?, ?> node) {
        File file = new File(System.getProperty("karaf.data", "."), "failed-recovery-" + kind + "-" + this.shardName + ".xml");
        NormalizedNodeXMLOutput.toFile(file, node);
        return file;
    }

    public void applyRecoverySnapshot(Snapshot.State snapshotState) {
        if (!(snapshotState instanceof ShardSnapshotState)) {
            this.log.debug("{}: applyRecoverySnapshot ignoring snapshot: {}", (Object)snapshotState);
        }
        this.log.debug("{}: Applying recovered snapshot", (Object)this.shardName);
        ShardDataTreeSnapshot shardSnapshot = ((ShardSnapshotState)snapshotState).getSnapshot();
        try {
            this.store.applyRecoverySnapshot(shardSnapshot);
        }
        catch (Exception e) {
            File f = this.writeRoot("snapshot", shardSnapshot.getRootNode().orElse(null));
            throw new IllegalStateException(String.format("%s: Failed to apply recovery snapshot %s. Node data was written to file %s", this.shardName, shardSnapshot, f), e);
        }
    }

    public Snapshot getRestoreFromSnapshot() {
        return this.restoreFromSnapshot;
    }
}

