/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.Status;
import akka.japi.Creator;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActorWithMetering;
import org.opendaylight.controller.cluster.datastore.AbstractShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ShardReadTransaction;
import org.opendaylight.controller.cluster.datastore.ShardReadWriteTransaction;
import org.opendaylight.controller.cluster.datastore.ShardWriteTransaction;
import org.opendaylight.controller.cluster.datastore.TransactionType;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.shard.ShardStats;
import org.opendaylight.controller.cluster.datastore.messages.CloseTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CloseTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.DataExists;
import org.opendaylight.controller.cluster.datastore.messages.DataExistsReply;
import org.opendaylight.controller.cluster.datastore.messages.PersistAbortTransactionPayload;
import org.opendaylight.controller.cluster.datastore.messages.ReadData;
import org.opendaylight.controller.cluster.datastore.messages.ReadDataReply;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public abstract class ShardTransaction
extends AbstractUntypedActorWithMetering {
    private final ActorRef shardActor;
    private final ShardStats shardStats;
    private final TransactionIdentifier transactionId;

    protected ShardTransaction(ActorRef shardActor, ShardStats shardStats, TransactionIdentifier transactionId) {
        super("shard-tx");
        this.shardActor = shardActor;
        this.shardStats = shardStats;
        this.transactionId = (TransactionIdentifier)Preconditions.checkNotNull((Object)transactionId);
    }

    public static Props props(TransactionType type, AbstractShardDataTreeTransaction<?> transaction, ActorRef shardActor, DatastoreContext datastoreContext, ShardStats shardStats) {
        return Props.create((Creator)new ShardTransactionCreator(type, transaction, shardActor, datastoreContext, shardStats));
    }

    protected abstract AbstractShardDataTreeTransaction<?> getDOMStoreTransaction();

    protected ActorRef getShardActor() {
        return this.shardActor;
    }

    protected final TransactionIdentifier getTransactionId() {
        return this.transactionId;
    }

    public void handleReceive(Object message) {
        if (CloseTransaction.isSerializedType(message)) {
            this.closeTransaction(true);
        } else if (message instanceof ReceiveTimeout) {
            this.LOG.debug("Got ReceiveTimeout for inactivity - closing transaction {}", (Object)this.transactionId);
            this.closeTransaction(false);
        } else {
            this.unknownMessage(message);
        }
    }

    protected boolean returnCloseTransactionReply() {
        return true;
    }

    private void closeTransaction(boolean sendReply) {
        this.getDOMStoreTransaction().abortFromTransactionActor();
        this.shardActor.tell((Object)new PersistAbortTransactionPayload(this.transactionId), ActorRef.noSender());
        if (sendReply && this.returnCloseTransactionReply()) {
            this.getSender().tell((Object)new CloseTransactionReply(), this.getSelf());
        }
        this.getSelf().tell((Object)PoisonPill.getInstance(), this.getSelf());
    }

    private boolean checkClosed(AbstractShardDataTreeTransaction<?> transaction) {
        boolean ret = transaction.isClosed();
        if (ret) {
            this.shardStats.incrementFailedReadTransactionsCount();
            this.getSender().tell((Object)new Status.Failure((Throwable)new ReadFailedException("Transaction is closed", new RpcError[0])), this.getSelf());
        }
        return ret;
    }

    protected void readData(AbstractShardDataTreeTransaction<?> transaction, ReadData message) {
        if (this.checkClosed(transaction)) {
            return;
        }
        YangInstanceIdentifier path = message.getPath();
        Optional optional = transaction.getSnapshot().readNode(path);
        ReadDataReply readDataReply = new ReadDataReply((NormalizedNode)optional.orNull(), message.getVersion());
        this.sender().tell(readDataReply.toSerializable(), this.self());
    }

    protected void dataExists(AbstractShardDataTreeTransaction<?> transaction, DataExists message) {
        if (this.checkClosed(transaction)) {
            return;
        }
        YangInstanceIdentifier path = message.getPath();
        boolean exists = transaction.getSnapshot().readNode(path).isPresent();
        this.getSender().tell(new DataExistsReply(exists, message.getVersion()).toSerializable(), this.getSelf());
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Some fields are not Serializable but we don't create remote instances of this actor and thus don't need it to be Serializable.")
    private static class ShardTransactionCreator
    implements Creator<ShardTransaction> {
        private static final long serialVersionUID = 1L;
        final AbstractShardDataTreeTransaction<?> transaction;
        final ActorRef shardActor;
        final DatastoreContext datastoreContext;
        final ShardStats shardStats;
        final TransactionType type;

        ShardTransactionCreator(TransactionType type, AbstractShardDataTreeTransaction<?> transaction, ActorRef shardActor, DatastoreContext datastoreContext, ShardStats shardStats) {
            this.transaction = (AbstractShardDataTreeTransaction)Preconditions.checkNotNull(transaction);
            this.shardActor = shardActor;
            this.shardStats = shardStats;
            this.datastoreContext = datastoreContext;
            this.type = type;
        }

        public ShardTransaction create() throws Exception {
            ShardTransaction tx;
            switch (this.type) {
                case READ_ONLY: {
                    tx = new ShardReadTransaction(this.transaction, this.shardActor, this.shardStats);
                    break;
                }
                case READ_WRITE: {
                    tx = new ShardReadWriteTransaction((ReadWriteShardDataTreeTransaction)this.transaction, this.shardActor, this.shardStats);
                    break;
                }
                case WRITE_ONLY: {
                    tx = new ShardWriteTransaction((ReadWriteShardDataTreeTransaction)this.transaction, this.shardActor, this.shardStats);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled transaction type " + (Object)((Object)this.type));
                }
            }
            tx.getContext().setReceiveTimeout(this.datastoreContext.getShardTransactionIdleTimeout());
            return tx;
        }
    }
}

