/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.PoisonPill;
import akka.actor.Status;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.ReadWriteShardDataTreeTransaction;
import org.opendaylight.controller.cluster.datastore.ShardTransaction;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.shard.ShardStats;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModificationsReply;
import org.opendaylight.controller.cluster.datastore.messages.DataExists;
import org.opendaylight.controller.cluster.datastore.messages.ForwardedReadyTransaction;
import org.opendaylight.controller.cluster.datastore.messages.ReadData;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;

public class ShardWriteTransaction
extends ShardTransaction {
    private int totalBatchedModificationsReceived;
    private Exception lastBatchedModificationsException;
    private final ReadWriteShardDataTreeTransaction transaction;

    public ShardWriteTransaction(ReadWriteShardDataTreeTransaction transaction, ActorRef shardActor, ShardStats shardStats) {
        super(shardActor, shardStats, transaction.getIdentifier());
        this.transaction = transaction;
    }

    protected ReadWriteShardDataTreeTransaction getDOMStoreTransaction() {
        return this.transaction;
    }

    @Override
    public void handleReceive(Object message) {
        if (message instanceof BatchedModifications) {
            this.batchedModifications((BatchedModifications)message);
        } else {
            super.handleReceive(message);
        }
    }

    private void batchedModifications(BatchedModifications batched) {
        block9: {
            if (this.checkClosed()) {
                if (batched.isReady()) {
                    this.getSelf().tell((Object)PoisonPill.getInstance(), this.getSelf());
                }
                return;
            }
            try {
                for (Modification modification : batched.getModifications()) {
                    modification.apply((DataTreeModification)this.transaction.getSnapshot());
                }
                ++this.totalBatchedModificationsReceived;
                if (batched.isReady()) {
                    if (this.lastBatchedModificationsException != null) {
                        throw this.lastBatchedModificationsException;
                    }
                    if (this.totalBatchedModificationsReceived != batched.getTotalMessagesSent()) {
                        throw new IllegalStateException(String.format("The total number of batched messages received %d does not match the number sent %d", this.totalBatchedModificationsReceived, batched.getTotalMessagesSent()));
                    }
                    this.readyTransaction(false, batched.isDoCommitOnReady(), batched.getVersion());
                } else {
                    this.getSender().tell((Object)new BatchedModificationsReply(batched.getModifications().size()), this.getSelf());
                }
            }
            catch (Exception e) {
                this.lastBatchedModificationsException = e;
                this.getSender().tell((Object)new Status.Failure((Throwable)e), this.getSelf());
                if (!batched.isReady()) break block9;
                this.getSelf().tell((Object)PoisonPill.getInstance(), this.getSelf());
            }
        }
    }

    protected final void dataExists(DataExists message) {
        super.dataExists(this.transaction, message);
    }

    protected final void readData(ReadData message) {
        super.readData(this.transaction, message);
    }

    private boolean checkClosed() {
        if (this.transaction.isClosed()) {
            this.getSender().tell((Object)new Status.Failure((Throwable)new IllegalStateException("Transaction is closed, no modifications allowed")), this.getSelf());
            return true;
        }
        return false;
    }

    private void readyTransaction(boolean returnSerialized, boolean doImmediateCommit, short clientTxVersion) {
        TransactionIdentifier transactionID = this.getTransactionId();
        this.LOG.debug("readyTransaction : {}", (Object)transactionID);
        this.getShardActor().forward((Object)new ForwardedReadyTransaction(transactionID, clientTxVersion, this.transaction, doImmediateCommit), (ActorContext)this.getContext());
        this.getSelf().tell((Object)PoisonPill.getInstance(), this.getSelf());
    }
}

