/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.controller.cluster.datastore.TransactionContext;
import org.opendaylight.controller.cluster.datastore.TransactionProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TransactionContextCleanup
extends FinalizablePhantomReference<TransactionProxy> {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionContextCleanup.class);
    private static final FinalizableReferenceQueue QUEUE = new FinalizableReferenceQueue();
    private static final Map<TransactionContext, TransactionContextCleanup> CACHE = new ConcurrentHashMap<TransactionContext, TransactionContextCleanup>();
    private final TransactionContext cleanup;

    private TransactionContextCleanup(TransactionProxy referent, TransactionContext cleanup) {
        super((Object)referent, QUEUE);
        this.cleanup = cleanup;
    }

    static void track(TransactionProxy referent, TransactionContext cleanup) {
        TransactionContextCleanup ret = new TransactionContextCleanup(referent, cleanup);
        CACHE.put(cleanup, ret);
    }

    public void finalizeReferent() {
        LOG.trace("Cleaning up {} Tx actors {}", (Object)this.cleanup);
        if (CACHE.remove(this.cleanup) != null) {
            this.cleanup.closeTransaction();
        }
    }

    static void untrack(TransactionContext cleanup) {
        CACHE.remove(cleanup);
    }
}

