/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSelection;
import akka.dispatch.Futures;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.OperationLimiter;
import org.opendaylight.controller.cluster.datastore.TransactionContext;
import org.opendaylight.controller.cluster.datastore.TransactionOperation;
import org.opendaylight.controller.cluster.datastore.utils.ActorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Future;
import scala.concurrent.Promise;

class TransactionContextWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionContextWrapper.class);
    @GuardedBy(value="queuedTxOperations")
    private final List<TransactionOperation> queuedTxOperations = Lists.newArrayList();
    private final TransactionIdentifier identifier;
    private volatile TransactionContext transactionContext;
    private final OperationLimiter limiter;

    TransactionContextWrapper(TransactionIdentifier identifier, ActorContext actorContext) {
        this.identifier = (TransactionIdentifier)Preconditions.checkNotNull((Object)identifier);
        this.limiter = new OperationLimiter(identifier, actorContext.getDatastoreContext().getShardBatchedModificationCount() + 1, TimeUnit.MILLISECONDS.toSeconds(actorContext.getDatastoreContext().getOperationTimeoutInMillis()));
    }

    TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    TransactionIdentifier getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueTransactionOperation(TransactionOperation operation) {
        boolean invokeOperation;
        List<TransactionOperation> list = this.queuedTxOperations;
        synchronized (list) {
            if (this.transactionContext == null) {
                LOG.debug("Tx {} Queuing TransactionOperation", (Object)this.getIdentifier());
                this.queuedTxOperations.add(operation);
                invokeOperation = false;
            } else {
                invokeOperation = true;
            }
        }
        if (invokeOperation) {
            operation.invoke(this.transactionContext);
        } else {
            this.limiter.acquire();
        }
    }

    void maybeExecuteTransactionOperation(TransactionOperation op) {
        if (this.transactionContext != null) {
            op.invoke(this.transactionContext);
        } else {
            this.enqueueTransactionOperation(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executePriorTransactionOperations(TransactionContext localTransactionContext) {
        block3: while (true) {
            ArrayList<TransactionOperation> operationsBatch;
            Object object = this.queuedTxOperations;
            synchronized (object) {
                if (this.queuedTxOperations.isEmpty()) {
                    localTransactionContext.operationHandOffComplete();
                    if (!localTransactionContext.usesOperationLimiting()) {
                        this.limiter.releaseAll();
                    }
                    this.transactionContext = localTransactionContext;
                    break;
                }
                operationsBatch = new ArrayList<TransactionOperation>(this.queuedTxOperations);
                this.queuedTxOperations.clear();
            }
            object = operationsBatch.iterator();
            while (true) {
                if (!object.hasNext()) continue block3;
                TransactionOperation oper = (TransactionOperation)object.next();
                oper.invoke(localTransactionContext);
            }
            break;
        }
    }

    Future<ActorSelection> readyTransaction() {
        if (this.transactionContext != null) {
            return this.transactionContext.readyTransaction();
        }
        final Promise promise = Futures.promise();
        this.enqueueTransactionOperation(new TransactionOperation(){

            @Override
            public void invoke(TransactionContext newTransactionContext) {
                promise.completeWith(newTransactionContext.readyTransaction());
            }
        });
        return promise.future();
    }

    public OperationLimiter getLimiter() {
        return this.limiter;
    }
}

