/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.FileModuleShardConfigProvider;
import org.opendaylight.controller.cluster.datastore.config.ModuleConfig;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfigProvider;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfiguration;
import org.opendaylight.controller.cluster.datastore.config.PrefixShardConfiguration;
import org.opendaylight.controller.cluster.datastore.config.ShardConfig;
import org.opendaylight.controller.cluster.datastore.shardstrategy.PrefixShardStrategy;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategy;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategyFactory;
import org.opendaylight.controller.cluster.datastore.utils.ClusterUtils;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class ConfigurationImpl
implements Configuration {
    private volatile Map<String, ModuleConfig> moduleConfigMap;
    private volatile Map<DOMDataTreeIdentifier, PrefixShardConfiguration> prefixConfigMap = Collections.emptyMap();
    private volatile Map<String, String> namespaceToModuleName;
    private volatile Set<String> allShardNames;

    public ConfigurationImpl(String moduleShardsConfigPath, String modulesConfigPath) {
        this(new FileModuleShardConfigProvider(moduleShardsConfigPath, modulesConfigPath));
    }

    public ConfigurationImpl(ModuleShardConfigProvider provider) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, ModuleConfig.Builder> e : provider.retrieveModuleConfigs(this).entrySet()) {
            mapBuilder.put((Object)e.getKey(), (Object)e.getValue().build());
        }
        this.moduleConfigMap = mapBuilder.build();
        this.allShardNames = ConfigurationImpl.createAllShardNames(this.moduleConfigMap.values());
        this.namespaceToModuleName = ConfigurationImpl.createNamespaceToModuleName(this.moduleConfigMap.values());
    }

    private static Set<String> createAllShardNames(Iterable<ModuleConfig> moduleConfigs) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ModuleConfig moduleConfig : moduleConfigs) {
            builder.addAll(moduleConfig.getShardNames());
        }
        return builder.build();
    }

    private static Map<String, String> createNamespaceToModuleName(Iterable<ModuleConfig> moduleConfigs) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ModuleConfig moduleConfig : moduleConfigs) {
            if (moduleConfig.getNamespace() == null) continue;
            builder.put((Object)moduleConfig.getNamespace(), (Object)moduleConfig.getName());
        }
        return builder.build();
    }

    @Override
    public Collection<String> getMemberShardNames(MemberName memberName) {
        Preconditions.checkNotNull((Object)memberName, (Object)"memberName should not be null");
        ArrayList<String> shards = new ArrayList<String>();
        for (ModuleConfig moduleConfig : this.moduleConfigMap.values()) {
            for (ShardConfig shardConfig : moduleConfig.getShardConfigs()) {
                if (!shardConfig.getReplicas().contains(memberName)) continue;
                shards.add(shardConfig.getName());
            }
        }
        return shards;
    }

    @Override
    public String getModuleNameFromNameSpace(String nameSpace) {
        Preconditions.checkNotNull((Object)nameSpace, (Object)"nameSpace should not be null");
        return this.namespaceToModuleName.get(nameSpace);
    }

    @Override
    public ShardStrategy getStrategyForModule(String moduleName) {
        Preconditions.checkNotNull((Object)moduleName, (Object)"moduleName should not be null");
        ModuleConfig moduleConfig = this.moduleConfigMap.get(moduleName);
        return moduleConfig != null ? moduleConfig.getShardStrategy() : null;
    }

    @Override
    public String getShardNameForModule(String moduleName) {
        Preconditions.checkNotNull((Object)moduleName, (Object)"moduleName should not be null");
        ModuleConfig moduleConfig = this.moduleConfigMap.get(moduleName);
        Collection<Object> shardConfigs = moduleConfig != null ? moduleConfig.getShardConfigs() : Collections.emptySet();
        return !shardConfigs.isEmpty() ? ((ShardConfig)shardConfigs.iterator().next()).getName() : null;
    }

    @Override
    @Nullable
    public String getShardNameForPrefix(@Nonnull DOMDataTreeIdentifier prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix should not be null");
        Map.Entry<DOMDataTreeIdentifier, Object> bestMatchEntry = new AbstractMap.SimpleEntry<DOMDataTreeIdentifier, Object>(new DOMDataTreeIdentifier(prefix.getDatastoreType(), YangInstanceIdentifier.EMPTY), null);
        for (Map.Entry<DOMDataTreeIdentifier, PrefixShardConfiguration> entry : this.prefixConfigMap.entrySet()) {
            if (!entry.getKey().contains(prefix) || entry.getKey().getRootIdentifier().getPathArguments().size() <= ((DOMDataTreeIdentifier)bestMatchEntry.getKey()).getRootIdentifier().getPathArguments().size()) continue;
            bestMatchEntry = entry;
        }
        return ClusterUtils.getCleanShardName(((DOMDataTreeIdentifier)bestMatchEntry.getKey()).getRootIdentifier());
    }

    @Override
    public Collection<MemberName> getMembersFromShardName(String shardName) {
        Preconditions.checkNotNull((Object)shardName, (Object)"shardName should not be null");
        for (ModuleConfig moduleConfig : this.moduleConfigMap.values()) {
            ShardConfig shardConfig = moduleConfig.getShardConfig(shardName);
            if (shardConfig == null) continue;
            return shardConfig.getReplicas();
        }
        for (PrefixShardConfiguration prefixConfig : this.prefixConfigMap.values()) {
            if (!shardName.equals(ClusterUtils.getCleanShardName(prefixConfig.getPrefix().getRootIdentifier()))) continue;
            return prefixConfig.getShardMemberNames();
        }
        return Collections.emptyList();
    }

    @Override
    public Set<String> getAllShardNames() {
        return this.allShardNames;
    }

    @Override
    public Collection<MemberName> getUniqueMemberNamesForAllShards() {
        HashSet<MemberName> allNames = new HashSet<MemberName>();
        for (String shardName : this.getAllShardNames()) {
            allNames.addAll(this.getMembersFromShardName(shardName));
        }
        return allNames;
    }

    @Override
    public synchronized void addModuleShardConfiguration(ModuleShardConfiguration config) {
        Preconditions.checkNotNull((Object)config, (Object)"ModuleShardConfiguration should not be null");
        ModuleConfig moduleConfig = ModuleConfig.builder(config.getModuleName()).nameSpace(config.getNamespace().toASCIIString()).shardStrategy(this.createShardStrategy(config.getModuleName(), config.getShardStrategyName())).shardConfig(config.getShardName(), config.getShardMemberNames()).build();
        this.updateModuleConfigMap(moduleConfig);
        this.namespaceToModuleName = ImmutableMap.builder().putAll(this.namespaceToModuleName).put((Object)moduleConfig.getNamespace(), (Object)moduleConfig.getName()).build();
        this.allShardNames = ImmutableSet.builder().addAll(this.allShardNames).add((Object)config.getShardName()).build();
    }

    @Override
    public void addPrefixShardConfiguration(@Nonnull PrefixShardConfiguration config) {
        Preconditions.checkNotNull((Object)config, (Object)"PrefixShardConfiguration cannot be null");
        this.addPrefixConfig(config);
        this.allShardNames = ImmutableSet.builder().addAll(this.allShardNames).add((Object)ClusterUtils.getCleanShardName(config.getPrefix().getRootIdentifier())).build();
    }

    @Override
    public void removePrefixShardConfiguration(@Nonnull DOMDataTreeIdentifier prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"Prefix cannot be null");
        this.removePrefixConfig(prefix);
        HashSet<String> temp = new HashSet<String>(this.allShardNames);
        temp.remove(ClusterUtils.getCleanShardName(prefix.getRootIdentifier()));
        this.allShardNames = ImmutableSet.copyOf(temp);
    }

    @Override
    public Map<DOMDataTreeIdentifier, PrefixShardConfiguration> getAllPrefixShardConfigurations() {
        return ImmutableMap.copyOf(this.prefixConfigMap);
    }

    private void addPrefixConfig(PrefixShardConfiguration config) {
        HashMap<DOMDataTreeIdentifier, PrefixShardConfiguration> newPrefixConfigMap = new HashMap<DOMDataTreeIdentifier, PrefixShardConfiguration>(this.prefixConfigMap);
        newPrefixConfigMap.put(config.getPrefix(), config);
        this.prefixConfigMap = ImmutableMap.copyOf(newPrefixConfigMap);
    }

    private void removePrefixConfig(DOMDataTreeIdentifier prefix) {
        HashMap<DOMDataTreeIdentifier, PrefixShardConfiguration> newPrefixConfigMap = new HashMap<DOMDataTreeIdentifier, PrefixShardConfiguration>(this.prefixConfigMap);
        newPrefixConfigMap.remove(prefix);
        this.prefixConfigMap = ImmutableMap.copyOf(newPrefixConfigMap);
    }

    private ShardStrategy createShardStrategy(String moduleName, String shardStrategyName) {
        return ShardStrategyFactory.newShardStrategyInstance(moduleName, shardStrategyName, this);
    }

    @Override
    public boolean isShardConfigured(String shardName) {
        Preconditions.checkNotNull((Object)shardName, (Object)"shardName should not be null");
        return this.allShardNames.contains(shardName);
    }

    @Override
    public void addMemberReplicaForShard(String shardName, MemberName newMemberName) {
        Preconditions.checkNotNull((Object)shardName, (Object)"shardName should not be null");
        Preconditions.checkNotNull((Object)newMemberName, (Object)"MemberName should not be null");
        for (ModuleConfig moduleConfig : this.moduleConfigMap.values()) {
            ShardConfig shardConfig = moduleConfig.getShardConfig(shardName);
            if (shardConfig == null) continue;
            HashSet<MemberName> replicas = new HashSet<MemberName>(shardConfig.getReplicas());
            replicas.add(newMemberName);
            this.updateModuleConfigMap(ModuleConfig.builder(moduleConfig).shardConfig(shardName, replicas).build());
            return;
        }
    }

    @Override
    public void removeMemberReplicaForShard(String shardName, MemberName newMemberName) {
        Preconditions.checkNotNull((Object)shardName, (Object)"shardName should not be null");
        Preconditions.checkNotNull((Object)newMemberName, (Object)"MemberName should not be null");
        for (ModuleConfig moduleConfig : this.moduleConfigMap.values()) {
            ShardConfig shardConfig = moduleConfig.getShardConfig(shardName);
            if (shardConfig == null) continue;
            HashSet<MemberName> replicas = new HashSet<MemberName>(shardConfig.getReplicas());
            replicas.remove(newMemberName);
            this.updateModuleConfigMap(ModuleConfig.builder(moduleConfig).shardConfig(shardName, replicas).build());
            return;
        }
    }

    @Override
    public ShardStrategy getStrategyForPrefix(@Nonnull DOMDataTreeIdentifier prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"Prefix cannot be null");
        Map.Entry<DOMDataTreeIdentifier, Object> bestMatchEntry = new AbstractMap.SimpleEntry<DOMDataTreeIdentifier, Object>(new DOMDataTreeIdentifier(prefix.getDatastoreType(), YangInstanceIdentifier.EMPTY), null);
        for (Map.Entry<DOMDataTreeIdentifier, PrefixShardConfiguration> entry : this.prefixConfigMap.entrySet()) {
            if (!entry.getKey().contains(prefix) || entry.getKey().getRootIdentifier().getPathArguments().size() <= ((DOMDataTreeIdentifier)bestMatchEntry.getKey()).getRootIdentifier().getPathArguments().size()) continue;
            bestMatchEntry = entry;
        }
        if (bestMatchEntry.getValue() == null) {
            return null;
        }
        return new PrefixShardStrategy(ClusterUtils.getCleanShardName(((DOMDataTreeIdentifier)bestMatchEntry.getKey()).getRootIdentifier()), ((DOMDataTreeIdentifier)bestMatchEntry.getKey()).getRootIdentifier());
    }

    private void updateModuleConfigMap(ModuleConfig moduleConfig) {
        HashMap<String, ModuleConfig> newModuleConfigMap = new HashMap<String, ModuleConfig>(this.moduleConfigMap);
        newModuleConfigMap.put(moduleConfig.getName(), moduleConfig);
        this.moduleConfigMap = ImmutableMap.copyOf(newModuleConfigMap);
    }
}

