/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ModuleConfig;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfigProvider;
import org.opendaylight.controller.cluster.datastore.shardstrategy.ShardStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileModuleShardConfigProvider
implements ModuleShardConfigProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FileModuleShardConfigProvider.class);
    private final String moduleShardsConfigPath;
    private final String modulesConfigPath;

    public FileModuleShardConfigProvider(String moduleShardsConfigPath, String modulesConfigPath) {
        this.moduleShardsConfigPath = moduleShardsConfigPath;
        this.modulesConfigPath = modulesConfigPath;
    }

    @Override
    public Map<String, ModuleConfig.Builder> retrieveModuleConfigs(Configuration configuration) {
        File moduleShardsFile = new File("./configuration/initial/" + this.moduleShardsConfigPath);
        File modulesFile = new File("./configuration/initial/" + this.modulesConfigPath);
        Config moduleShardsConfig = null;
        if (moduleShardsFile.exists()) {
            LOG.info("module shards config file exists - reading config from it");
            moduleShardsConfig = ConfigFactory.parseFile((File)moduleShardsFile);
        } else {
            LOG.warn("module shards configuration read from resource");
            moduleShardsConfig = ConfigFactory.load((String)this.moduleShardsConfigPath);
        }
        Config modulesConfig = null;
        if (modulesFile.exists()) {
            LOG.info("modules config file exists - reading config from it");
            modulesConfig = ConfigFactory.parseFile((File)modulesFile);
        } else {
            LOG.warn("modules configuration read from resource");
            modulesConfig = ConfigFactory.load((String)this.modulesConfigPath);
        }
        Map<String, ModuleConfig.Builder> moduleConfigMap = FileModuleShardConfigProvider.readModuleShardsConfig(moduleShardsConfig);
        FileModuleShardConfigProvider.readModulesConfig(modulesConfig, moduleConfigMap, configuration);
        return moduleConfigMap;
    }

    private static void readModulesConfig(Config modulesConfig, Map<String, ModuleConfig.Builder> moduleConfigMap, Configuration configuration) {
        List modulesConfigObjectList = modulesConfig.getObjectList("modules");
        for (ConfigObject o : modulesConfigObjectList) {
            ConfigObjectWrapper wrapper = new ConfigObjectWrapper(o);
            String moduleName = wrapper.stringValue("name");
            ModuleConfig.Builder builder = moduleConfigMap.computeIfAbsent(moduleName, ModuleConfig::builder);
            builder.nameSpace(wrapper.stringValue("namespace"));
            builder.shardStrategy(ShardStrategyFactory.newShardStrategyInstance(moduleName, wrapper.stringValue("shard-strategy"), configuration));
        }
    }

    private static Map<String, ModuleConfig.Builder> readModuleShardsConfig(Config moduleShardsConfig) {
        List moduleShardsConfigObjectList = moduleShardsConfig.getObjectList("module-shards");
        HashMap<String, ModuleConfig.Builder> moduleConfigMap = new HashMap<String, ModuleConfig.Builder>();
        for (ConfigObject moduleShardConfigObject : moduleShardsConfigObjectList) {
            String moduleName = moduleShardConfigObject.get((Object)"name").unwrapped().toString();
            ModuleConfig.Builder builder = ModuleConfig.builder(moduleName);
            List shardsConfigObjectList = moduleShardConfigObject.toConfig().getObjectList("shards");
            for (ConfigObject shard : shardsConfigObjectList) {
                String shardName = shard.get((Object)"name").unwrapped().toString();
                List<MemberName> replicas = shard.toConfig().getStringList("replicas").stream().map(MemberName::forName).collect(Collectors.toList());
                builder.shardConfig(shardName, replicas);
            }
            moduleConfigMap.put(moduleName, builder);
        }
        return moduleConfigMap;
    }

    private static class ConfigObjectWrapper {
        private final ConfigObject configObject;

        ConfigObjectWrapper(ConfigObject configObject) {
            this.configObject = configObject;
        }

        public String stringValue(String name) {
            return this.configObject.get((Object)name).unwrapped().toString();
        }
    }
}

