/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.config;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.MemberName;

public class ModuleShardConfiguration {
    private final URI namespace;
    private final String moduleName;
    private final String shardName;
    private final String shardStrategyName;
    private final Collection<MemberName> shardMemberNames;

    public ModuleShardConfiguration(@Nonnull URI namespace, @Nonnull String moduleName, @Nonnull String shardName, @Nullable String shardStrategyName, @Nonnull Collection<MemberName> shardMemberNames) {
        this.namespace = (URI)Preconditions.checkNotNull((Object)namespace, (Object)"nameSpace should not be null");
        this.moduleName = (String)Preconditions.checkNotNull((Object)moduleName, (Object)"moduleName should not be null");
        this.shardName = (String)Preconditions.checkNotNull((Object)shardName, (Object)"shardName should not be null");
        this.shardStrategyName = shardStrategyName;
        this.shardMemberNames = (Collection)Preconditions.checkNotNull(shardMemberNames, (Object)"shardMemberNames");
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getShardName() {
        return this.shardName;
    }

    public String getShardStrategyName() {
        return this.shardStrategyName;
    }

    public Collection<MemberName> getShardMemberNames() {
        return this.shardMemberNames;
    }

    public String toString() {
        return "ModuleShardConfiguration [namespace=" + this.namespace + ", moduleName=" + this.moduleName + ", shardName=" + this.shardName + ", shardMemberNames=" + this.shardMemberNames + ", shardStrategyName=" + this.shardStrategyName + "]";
    }
}

